/* $Id: plugadder,v 1.46 1999/03/19 00:13:57 donwm Exp $ */
/* Copyright (C) 1995 - 1999, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/* VXIplug&play Instrument Driver for the HP E1432A */

#ifndef hpe1432_INCLUDE 
#define hpe1432_INCLUDE
#include "visa.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif




#define VI_WARN_NSUP_ID_QUERY       (0x30101)
#define VI_WARN_NSUP_RESET          (0x30102)
#define VI_WARN_NSUP_SELF_TEST      (0x30103)
#define VI_WARN_NSUP_ERROR_QUERY    (0x30104)
#define VI_WARN_NSUP_REV_QUERY      (0x30105)

#define VI_ERROR_PARAMETER1         (_VI_ERROR+0xB0001)
#define VI_ERROR_PARAMETER2         (_VI_ERROR+0xB0002)
#define VI_ERROR_PARAMETER3         (_VI_ERROR+0xB0003)
#define VI_ERROR_PARAMETER4         (_VI_ERROR+0xB0004)
#define VI_ERROR_PARAMETER5         (_VI_ERROR+0xB0005)
#define VI_ERROR_PARAMETER6         (_VI_ERROR+0xB0006)
#define VI_ERROR_PARAMETER7         (_VI_ERROR+0xB0007)
#define VI_ERROR_PARAMETER8         (_VI_ERROR+0xB0008)
#define VI_ERROR_FAIL_ID_QUERY      (_VI_ERROR+0xB0011)
#define VI_ERROR_INV_RESPONSE       (_VI_ERROR+0xB0012)
#define VI_ERROR_CALIBRATION_FAILURE (_VI_ERROR+0xB0013)

#define	HPE1432_IRQ_MEAS_WARNING		0x0100
#define	HPE1432_IRQ_BLOCK_READY		0x0200
#define	HPE1432_IRQ_MEAS_STATE_CHANGE	0x0400
#define	HPE1432_IRQ_TRIGGER		0x0800
#define	HPE1432_IRQ_OVERLOAD_CHANGE	0x1000
#define	HPE1432_IRQ_MEAS_ERROR		0x2000
#define	HPE1432_IRQ_TACHS_AVAIL		0x4000
#define HPE1432_IRQ_SRC_STATUS            0x8000

#define  HPE1432_PEAK_MODE_ON  581
#define  HPE1432_RMS_MODE_ON  591

#define HPE1432_STATUS2_TACH_OVERFLOW	0x0001
#define HPE1432_STATUS2_FIFO_EMPTIED	0x0002


#define	HPE1432_MEAS_STATE_MASK		0x001f
#define	HPE1432_MEAS_STATE_TESTED	0x0000
#define	HPE1432_MEAS_STATE_BOOTING	0x0001
#define	HPE1432_MEAS_STATE_BOOTING_WAIT1	0x0002
#define	HPE1432_MEAS_STATE_BOOTING_WAIT2	0x0003
#define	HPE1432_MEAS_STATE_BOOTED	0x0004
#define	HPE1432_MEAS_STATE_SYNC		0x0005
#define	HPE1432_MEAS_STATE_SYNC_WAIT1	0x0006
#define	HPE1432_MEAS_STATE_PRE_ARM	0x0007
#define	HPE1432_MEAS_STATE_PRE_ARM_WAIT2	0x0008
#define	HPE1432_MEAS_STATE_IDLE		0x0009
#define	HPE1432_MEAS_STATE_ARM		0x000a
#define	HPE1432_MEAS_STATE_ARM_WAIT1	0x000b
#define	HPE1432_MEAS_STATE_ARM_WAIT2	0x000c
#define	HPE1432_MEAS_STATE_TRIGGER	0x000d
#define	HPE1432_MEAS_STATE_CONVERT	0x000e
#define	HPE1432_MEAS_STATE_CONVERT_WAIT1	0x000f
#define	HPE1432_MEAS_STATE_CONVERT_WAIT2	0x0010
#define	HPE1432_MEAS_STATE_DUMMY	0x0011
#define	HPE1432_MEAS_STATE_ERROR	0x0012
#define	HPE1432_MEAS_STATE_ERROR_WAIT1	0x0013
#define	HPE1432_MEAS_STATE_ERROR_WAIT2	0x0014
#define	HPE1432_MEAS_STATE_DUMMY2	0x0015
#define	HPE1432_MEAS_STATE_TPUT		0x0016
#define	HPE1432_MEAS_STATE_MAX		0x0017


#define HPE1432_SRCBUF_RDY		0x00000000L
#define HPE1432_SRCBUF_AVAIL		0x00000001L
#define HPE1432_SRCBUF_FULL		0x00000002L
#define HPE1432_SRCBUF_OUT		0x00000004L

#define HPE1432_TACH_RAW_SIZE             16384
#define HPE1432_TACH_WRAP_COUNT		4294967296.0

/* duplicate of manual trigger */
#define HPE1432_TACH_EDGE_TRIGGER         440

#define	HPE1432_TRAILER_INFO_NOT_UNDERRANGE	0x0001
#define	HPE1432_TRAILER_INFO_OVERLOAD		0x0002
#define	HPE1432_TRAILER_INFO_OVERLOAD_COMM	0x0004
#define	HPE1432_TRAILER_INFO_TRIGGER		0x0008
#define	HPE1432_TRAILER_INFO_SETTLED		0x0010
#define	HPE1432_TRAILER_INFO_STOP			0x0020
#define	HPE1432_TRAILER_INFO_OT_RAMP_TOO_FAST	0x0040
#define	HPE1432_TRAILER_INFO_EXTEND		0x0080
#define	HPE1432_TRAILER_INFO_DEC_2_MASK		0x1f00
#define	HPE1432_TRAILER_INFO_DEC_2_SHIFT		8
#define	HPE1432_TRAILER_INFO_DEC_5		0x2000

#define	HPE1432_TTLTRG_01			250
#define	HPE1432_TTLTRG_23			251
#define	HPE1432_TTLTRG_45			252
#define	HPE1432_TTLTRG_67			253

/* SCA IDs */
#define	HPE1432_SCA_ID_UNKNOWN		-1    /* unknown whether SCA present */
#define	HPE1432_SCA_ID_IGNORE		0     /* disregard this SCA */
#define	HPE1432_SCA_ID_NONE		0x1f  /* no SCA present */
#define	HPE1432_SCA_ID_INPUT		0x18  /* undetermined input SCA */
#define	HPE1432_SCA_ID_SOURCE		0x19  /* undetermined source SCA */
#define	HPE1432_SCA_ID_TACH		4
#define	HPE1432_SCA_ID_CLARINET		6
#define	HPE1432_SCA_ID_VIBRATO		10
#define	HPE1432_SCA_ID_SONATA		12
#define	HPE1432_SCA_ID_SONATA_A		12
#define	HPE1432_SCA_ID_SONATA_B		13
#define	HPE1432_SCA_ID_CLARION		7

#define	HPE1432_DRAM_UNKNOWN		-1
#define	HPE1432_DRAM_IGNORE		0
#define	HPE1432_DRAM_4M			4
#define	HPE1432_DRAM_32M		32

/* Smart break-out box IDs */
#define HPE1432_BOB_ID_NONE		0
#define HPE1432_BOB_ID_CHARGE_PROTO	254
#define HPE1432_BOB_ID_MIKE_PROTO	253
#define HPE1432_BOB_ID_CHARGE		252
#define HPE1432_BOB_ID_MIKE		251
#define	HPE1432_BOB_ID_CHARGE2		250
#define	HPE1432_BOB_ID_MIKE2		249

/* Channel software characteristics */
#define	HPE1432_CHAN_TYPE_INPUT		0
#define	HPE1432_CHAN_TYPE_SOURCE	1
#define	HPE1432_CHAN_TYPE_TACH		2
#define	HPE1432_CHAN_TYPE_OTHER		3

#define HPE1432_OCTAVE_INT_TIME_STEP        2.0
#define HPE1432_WINDOW_SIZE_MAX             8192

/* VXI Address offsets of registers from module base address */
/* VXI Configuration registers */
#define	HPE1432_ID_REG			0
#define	HPE1432_LOGICAL_ADDRESS_REG	0
#define	HPE1432_DEVICE_TYPE_REG		2
#define	HPE1432_STATUS_REG		4
#define	HPE1432_CONTROL_REG		4
#define	HPE1432_OFFSET_REG		6
#define	HPE1432_PORT_CTL_REG		8
#define	HPE1432_PAGE_MAP_REG		10
#define	HPE1432_IRQ_CONFIG_REG		12
#define	HPE1432_IRQ_STATUS_REG		14
#define	HPE1432_IRQ_STATUS2_REG		16
#define	HPE1432_MEAS_STATE_REG		20
#define	HPE1432_FIFO_DATA_REG		24
#define	HPE1432_FIFO_COUNT_REG		30


#define HPE1432_NO_WARNING				0
#define HPE1432_LOST_NOT_ENOUGH_TACHS           	1
#define HPE1432_LOST_TOO_MANY_TACHS 	          	2
#define HPE1432_LOST_TOO_MANY_POINTS_REQUIRED   	3
#define HPE1432_LOST_DATA_SHIFTED_OUT_FIFO      	4
#define HPE1432_LOST_NOT_ENOUGH_DATA_FIFO       	5
#define HPE1432_LOST_RPM_TOO_HIGH               	6
#define HPE1432_LOST_RPM_TOO_LOW                	7
#define HPE1432_LOST_RESAMPLE_ERROR             	8
#define HPE1432_LOST_FIFO_EMPTIED			9
#define HPE1432_RPM_RAMP_TOO_FAST			10



/* misc defines, may be superfluous */

#define HPE1432_AC_RANGING_TIME 	 2.0
#define HPE1432_AC_SETTLING_TIME 	 15.0
#define HPE1432_ANALOG_DELAY 	 (11.925E-6)
#define HPE1432_CONTROL_A24_ENABLE 	 0x8000
#define HPE1432_CONTROL_RESET_OFF 	 0x0000
#define HPE1432_CONTROL_RESET_ON 	 0x0001
#define HPE1432_CONTROL_SYSFAIL_INHIBIT_OFF 	 0x0000
#define HPE1432_CONTROL_SYSFAIL_INHIBIT_ON 	 0x0002
#define	HPE1432_CVT_DATA_OVLD		1000000.0f
#define	HPE1432_CVT_DATA_NONE		-1000000.0f
#define HPE1432_DATA_MODE_OVERLAP_FREERUN 	 343
#define	HPE1432_DATA_SIZE_FRACT  758 /* internal use only */
#define HPE1432_DATA_SIZE_NONE 	 330
#define HPE1432_DATA_USER1 	 730
#define HPE1432_DATA_USER2 	 731
#define HPE1432_DECIMATION_MAX 	 16
#define HPE1432_DECIMATION_MIN 	 0
#define HPE1432_ENABLE_TYPE_USER1 	 274
#define HPE1432_ENABLE_TYPE_USER2 	 275
#define HPE1432_FFT_BLOCKSIZE_MAX 	 8192
#define HPE1432_FFT_BLOCKSIZE_MIN 	 64
#define HPE1432_GROUP_INFO_LIST_SOURCE 	 237
#define HPE1432_IRQ_ENABLE 	 0x0008
#define HPE1432_IRQ_PRIORITY 	 0x0007
#define HPE1432_IRQ_PRIORITY_MAX 	 0x0007
#define HPE1432_IRQ_PRIORITY_MIN 	 0x0001
#define HPE1432_IRQ_PRIORITY_NONE 	 0x0000
#define HPE1432_IRQ_SHIFT 	 8
#define HPE1432_LBUS_DISABLE 	 0x0000
#define HPE1432_LBUS_ENABLE 	 0x0001
#define HPE1432_LBUS_PIPE 	 0x0003
#define HPE1432_MAN_ID 	 0xfff
#define	HPE1432_MEAS_WATCHDOG_REG        0x088
#define HPE1432_MODEL_CODE 	 0x201
#define HPE1432_MODEL_CODE_E1432 	 0x201
#define HPE1432_MODEL_CODE_E1433 	 0x202
#define HPE1432_MODEL_CODE_E1434 	 0x203
#define	HPE1432_MODEL_CODE_NOT_BOOTED	 0x200
#define HPE1432_MODULES 	 255
#define HPE1432_MOD_MAX 	 15
#define HPE1432_MULTIPASS 	 621
#define HPE1432_NUM_SPANS_MAX 	 6
#define HPE1432_ONEPASS 	 620
#define HPE1432_ORDER_BLOCKSIZE_MAX 	 8192
#define HPE1432_OVHD 	 2.189784
#define HPE1432_SCAS 	 5
#define	HPE1432_SELFTEST_ALL_MODULES	0x0001
#define	HPE1432_SELFTEST_FAST		0x0002
#define	HPE1432_SELFTEST_LONG		0x0004
#define HPE1432_SELFTEST_VXI		0x0001 /* VXI interface */
#define HPE1432_SELFTEST_ASRAM		0x0002 /* substrate ASRAM */
#define HPE1432_SELFTEST_BSRAM		0x0004 /* substrate ASRAM */
#define HPE1432_SELFTEST_DSP		0x0008 /* 96002 */
#define HPE1432_SELFTEST_96K_HOSTPORT	0x0010 /* 96002 hostport */
#define HPE1432_SELFTEST_PLL		0x0020 /* substrate PLL */
#define HPE1432_SELFTEST_FLASH		0x0040 /* substrate FLASH PROM */
#define HPE1432_SELFTEST_MAIN		0x00ff /* all of the above */
#define HPE1432_SELFTEST_MAIN_IGNORE	0x0000 /* none of the above */
#define HPE1432_SELFTEST_NON_DL		0x0001 /* non download testing */
#define HPE1432_SELFTEST_DL		0x0002 /* download testing */
#define HPE1432_SELFTEST_STD_IO		0x0004 /* std in, out testing */
#define HPE1432_SELFTEST_BASIC		0x0001 /* non download testing */
#define HPE1432_SELFTEST_FULL		0x0003 /* non and download testing */
#define HPE1432_SELFTEST_FULL_STD_IO	0x0007 /* both plus std in, out */
#define HPE1432_SOURCE_COLA_DRPEPPER 	 182
#define	HPE1432_SOURCE_MODE_ARB_ROFF	 188
#define	HPE1432_SOURCE_MODE_BARB_ROFF	 189
#define HPE1432_SOURCE_MODE_BDNLD 	 179
#define HPE1432_SOURCE_MODE_BPRAND 	 185
#define HPE1432_SOURCE_MODE_BPRANDZ 	 187
#define HPE1432_SOURCE_MODE_BUSR 	 181
#define HPE1432_SOURCE_MODE_CLR 	 182
#define HPE1432_SOURCE_MODE_DNLD 	 178
#define HPE1432_SOURCE_MODE_MSINE 	 183
#define HPE1432_SOURCE_MODE_PRAND 	 184
#define HPE1432_SOURCE_MODE_PRANDZ 	 186
#define HPE1432_SOURCE_MODE_USR 	 180
#define HPE1432_SRCBUFFER_CONTINUOUS 	 1
#define HPE1432_SRCBUFFER_INIT_EMPTY 	 1
#define HPE1432_SRCBUFFER_INIT_RESET 	 2
#define HPE1432_SRCBUFFER_INIT_XFER 	 3
#define HPE1432_SRCBUFFER_PERIODIC_A 	 4
#define HPE1432_SRCBUFFER_PERIODIC_AB 	 2
#define HPE1432_SRCBUFFER_SWITCHEDAUTO 	 8
#define HPE1432_SRCBUFFER_SWITCHEDCMD 	 16
#define HPE1432_SRC_DATA_MODE_RAWCMD 	 0x0000000A
#define HPE1432_SRC_DATA_MODE_RAWDATA 	 0x00000009
#define HPE1432_SRC_DATA_MODE_RAWNACKCMD 	 0x0000000E
#define HPE1432_SRC_DATA_MODE_RAWREAD 	 0x0000000B
#define HPE1432_SRC_DATA_MODE_READID 	 0x0000000D
#define HPE1432_SRC_DATA_MODE_READNCLRSTATUS 	 0x0000000F
#define HPE1432_SRC_DATA_MODE_READSTATUS 	 0x0000000C
#define HPE1432_SRC_STATUS_OVERLOAD0 	 0x0800
#define HPE1432_SRC_STATUS_OVERLOAD2 	 0x0400
#define HPE1432_SRC_STATUS_OVERLOAD4 	 0x0200
#define HPE1432_SRC_STATUS_OVERREAD0 	 0x0020
#define HPE1432_SRC_STATUS_OVERREAD2 	 0x0010
#define HPE1432_SRC_STATUS_OVERREAD4 	 0x0008
#define HPE1432_SRC_STATUS_REG 	 0x8f0
#define HPE1432_SRC_STATUS_SHUTDOWN0 	 0x0100
#define HPE1432_SRC_STATUS_SHUTDOWN2 	 0x0080
#define HPE1432_SRC_STATUS_SHUTDOWN4 	 0x0040
#define HPE1432_SRC_XFRBUF_WDS_EMPTY 	 0
#define HPE1432_STATUS_A24_ACTIVE 	 0x8000
#define HPE1432_STATUS_BLOCK_READY 	 0x0800
#define HPE1432_STATUS_CMD_READY 	 0x0001
#define HPE1432_STATUS_DATA_READY 	 0x0400
#define HPE1432_STATUS_DONE 	 0x0080
#define HPE1432_STATUS_ERR_N 	 0x0040
#define HPE1432_STATUS_HW_OK 	 0x0010
#define HPE1432_STATUS_LOADED 	 0x0100
#define HPE1432_STATUS_MODID_N 	 0x4000
#define HPE1432_STATUS_PASSED 	 0x0004
#define HPE1432_STATUS_Q_RESP_READY 	 0x0002
#define HPE1432_STATUS_READY 	 0x0008
#define HPE1432_STATUS_ST_DONE 	 0x0200
#define HPE1432_STATUS_UNUSED1 	 0x0020
#define HPE1432_STATUS_UNUSED2 	 0x1000
#define HPE1432_STATUS_UNUSED3 	 0x2000
#define HPE1432_TACH_CHANS 	 2
#define HPE1432_USER1_DATA 	 350
#define HPE1432_USER2_DATA 	 351
#define HPE1432_WINDOW_USER1 	 713
#define HPE1432_WINDOW_USER2 	 714
#define HPE1432_ZAP_BOOT 	 1
#define HPE1432_ZAP_CLAR_BOOT 	 6
#define HPE1432_ZAP_CLAR_ID_CAL 	 3
#define HPE1432_ZAP_ID_CAL 	 2
#define HPE1432_ZAP_SRC12_BOOT 	 7
#define HPE1432_ZAP_SRC12_ID_CAL 	 4
#define HPE1432_ZAP_SRC34_BOOT 	 8
#define HPE1432_ZAP_SRC34_ID_CAL 	 5


#define ERR1432_DIAG_ERR_UNDIAGNOSED		-1592
#define ERR1432_DIAG_ERR_SUBST			-1593
#define ERR1432_DIAG_ERR_DRAM			-1594
#define ERR1432_DIAG_ERR_TACH			-1595
#define ERR1432_DIAG_ERR_SOURCE_FIT		-1596
#define ERR1432_DIAG_ERR_SOURCE_SCA0		-1597
#define ERR1432_DIAG_ERR_SOURCE_SCA1		-1598
#define ERR1432_DIAG_ERR_INPUT_SCA0		-1599
#define ERR1432_DIAG_ERR_INPUT_SCA1		-1600
#define ERR1432_DIAG_ERR_INPUT_SCA2		-1601
#define ERR1432_DIAG_ERR_INPUT_SCA3		-1602


#define	HPE1432_OCTAVE_AVG_MODE_DEF	760
#define	HPE1432_OCTAVE_HOLD_MODE_DEF	765
#define	HPE1432_OCTAVE_INT_TIME_DEF	1.0
#define	HPE1432_OCTAVE_MODE_DEF		752
#define	HPE1432_OCTAVE_START_FREQ_DEF	3.15
#define	HPE1432_OCTAVE_STOP_FREQ_DEF	20000.0
#define	HPE1432_OCTAVE_TIME_CONST_DEF	0.125
#define	HPE1432_OCTAVE_TIME_STEP_DEF	0.125

#define WARN1432_NO_WARNING                           0
#define WARN1432_LOST_NOT_ENOUGH_TACHS                1
#define WARN1432_LOST_TOO_MANY_TACHS                  2
#define WARN1432_LOST_TOO_MANY_POINTS_REQUIRED        3
#define WARN1432_LOST_DATA_SHIFTED_OUT_FIFO           4
#define WARN1432_LOST_NOT_ENOUGH_DATA_FIFO            5
#define WARN1432_LOST_RPM_TOO_HIGH                    6
#define WARN1432_LOST_RPM_TOO_LOW                     7
#define WARN1432_LOST_RESAMPLE_ERROR                  8
#define WARN1432_LOST_FIFO_EMPTIED                    9
#define WARN1432_RPM_RAMP_TOO_FAST                    10


/* end of misc defines */

#ifdef HPE1432_TRAILER_STRUCT
struct hpe1432_trailer
{
    ViReal32 trig_corr;
    ViReal32 zoom_corr;
    ViReal32 rpm1;
    ViReal32 rpm2;
    ViInt32 gap;
    ViInt32 info;
    ViReal32 peak;
    ViReal32 rms;
};
#endif


ViStatus _VI_FUNC hpe1432_setInternalDebug  (ViSession vi, ViInt32 group, ViInt32 intDebug);

ViStatus _VI_FUNC hpe1432_getInternalDebug  (ViSession vi, ViInt32 group, ViPInt32 intDebug);

ViStatus _VI_FUNC hpe1432_getInternalDebugLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);


ViStatus _VI_FUNC hpe1432_initA  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

ViStatus _VI_FUNC hpe1432_initB  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

ViStatus _VI_FUNC hpe1432_initB2  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

ViStatus _VI_FUNC hpe1432_initB3  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

ViStatus _VI_FUNC hpe1432_initC  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

#ifdef INSTR_CALLBACKS
typedef void ( * _VI_FUNCH hpe1432_callbackFunc )(ViInt32 value, ViInt32 reason);
#endif

ViStatus _VI_FUNC hpe1432_displayState  (ViSession vi);

/******   Used by Function hpe1432_setSrcOffMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRCOFF_MODE_RAMP  0
#define  HPE1432_SRCOFF_MODE_IMMED  1

ViStatus _VI_FUNC hpe1432_getSrcOffMode  (ViSession vi, ViInt32 group, ViPInt32 srcOffMode);

ViStatus _VI_FUNC hpe1432_setSrcOffMode  (ViSession vi, ViInt32 group, ViInt32 srcOffMode);

ViStatus _VI_FUNC hpe1432_setLockMode  (ViSession vi, ViInt32 mode);

ViStatus _VI_FUNC hpe1432_getLockMode  (ViSession vi, ViPInt32 mode);

ViStatus _VI_FUNC hpe1432_getUserDecimation  (ViSession vi, ViInt32 channel, ViPInt32 viparm);

ViStatus _VI_FUNC hpe1432_setUserDecimation  (ViSession vi, ViInt32 channel, ViInt32 dec);

ViStatus _VI_FUNC hpe1432_getUserFramesPerBlock  (ViSession vi, ViInt32 channel, ViPInt32 viparm);

ViStatus _VI_FUNC hpe1432_setUserFramesPerBlock  (ViSession vi, ViInt32 channel, ViInt32 fpb);

/* phpe1432.h follows */

/******   Used by Function hpe1432_armMeasure   *****/
#define  HPE1432_GROUP_ID_MAX  12288
#define  HPE1432_GROUP_ID_MIN  -8000
#define  HPE1432_NO_WAIT_FLAG  0
#define  HPE1432_WAIT_FLAG  1


/******   Used by Function hpe1432_armMeasureMasterFinish   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_armMeasureMasterSetup   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_armMeasureSlaveFinish   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_arrayControl   *****/
#define  HPE1432_ARRAYCONTROL_MAX_CHANS  200
#define  HPE1432_ARRAYCONTROL_MIN_CHANS  1


/******   Used by Function hpe1432_autoRange   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AUTO_RANGE_TIME_MAX  86400.0
#define  HPE1432_AUTO_RANGE_TIME_MIN  0.0


/******   Used by Function hpe1432_autoZero   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_blockAvailable   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_cachedParmUpdate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_callbackInstall   *****/
#define  HPE1432_CHANNEL_ID_MAX  12287
#define  HPE1432_CHANNEL_ID_MIN  1
#define  HPE1432_CB_MASK_MAX  16383
#define  HPE1432_CB_MASK_MIN  0


/******   Used by Function hpe1432_channelGroupAdd   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */


/******   Used by Function hpe1432_channelGroupRemove   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */


/******   Used by Function hpe1432_checkOverloads   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_checkSrcArbRdy   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRC_DATA_MODE_WAITA  4
#define  HPE1432_SRC_DATA_MODE_WAITB  5
#define  HPE1432_SRC_DATA_MODE_WAITAB  6


/******   Used by Function hpe1432_checkSrcOverload   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_checkSrcOverread   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_checkSrcShutdown   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_checkSrcUnderrun   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_createChannelGroup   *****/
#define  HPE1432_NUM_CHANNELS_MAX  4080
#define  HPE1432_NUM_CHANNELS_MIN  0


/******   Used by Function hpe1432_deleteChannelGroup   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_errorDetails   *****/
#define  HPE1432_ERROR_DETAIL_LEN_MAX  128
#define  HPE1432_ERROR_DETAIL_LEN_MIN  0


/******   Used by Function hpe1432_errorDetails2   *****/
/*  HPE1432_ERROR_DETAIL_LEN_MAX  */
/*  HPE1432_ERROR_DETAIL_LEN_MIN  */


/******   Used by Function hpe1432_error_message   *****/
#define  HPE1432_VISTATUS_MAX  2147483647
#define  HPE1432_VISTATUS_MIN  0


/******   Used by Function hpe1432_find   *****/
#define  HPE1432_FIND_LIST_SIZE_MAX  255
#define  HPE1432_FIND_LIST_SIZE_MIN  0
#define  HPE1432_FIND_RSRC_LEN_MAX  255
#define  HPE1432_FIND_RSRC_LEN_MIN  0


/******   Used by Function hpe1432_finishMeasure   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getActive   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAmpScale   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAmpScaleLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAntiAliasAnalog   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAntiAliasDigital   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAppendStatus   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getArmChannel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getArmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getArmTimeInterval   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getArmTimeIntervalLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAutoGroupMeas   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAutoRangeMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAutoTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgNumber   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgNumberLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgUpdate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgUpdateLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgWeight   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getAvgWeightLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getBlocksize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getBlocksizeCurrentMax   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getBlocksizeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalDac   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalDacLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalVoltage   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalVoltageLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalcData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCalin   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCenterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCenterFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getClockFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getClockFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getClockMaster   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getClockSource   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCoupling   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCouplingFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCouplingFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCurrentData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_DATA  350
#define  HPE1432_DATA_SIZE_FLOAT32  334
#define  HPE1432_DATA_SIZE_FLOAT64  759


/******   Used by Function hpe1432_getCurrentRpm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getCurrentValue   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */
#define  HPE1432_CURRENT_VAL_PEAK  589
#define  HPE1432_CURRENT_VAL_RMS  599
#define  HPE1432_CURRENT_VAL_FIFO_AVAIL  600


/******   Used by Function hpe1432_getCurrentValue32   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CURRENT_VAL_PEAK  */
/*  HPE1432_CURRENT_VAL_RMS  */
/*  HPE1432_CURRENT_VAL_FIFO_AVAIL  */


/******   Used by Function hpe1432_getDataMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDataPort   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDataRpm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDataSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDecimation   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDecimationOutput   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDecimationOversample   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDecimationUndersamp   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDecimationUndersampLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDeltaOrder   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDeltaOrderLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDutyCycle   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getDutyCycleLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getEnable   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_ENABLE_TYPE_TIME  270
#define  HPE1432_ENABLE_TYPE_FREQ  271
#define  HPE1432_ENABLE_TYPE_RESAMPLE  272
#define  HPE1432_ENABLE_TYPE_ORDER  273


/******   Used by Function hpe1432_getFifoSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFifoSizeCurrentMax   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFifoSizeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFilterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFilterFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFilterSettlingTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getFilterSettlingTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getGroupInfo   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_GROUP_INFO_NUM_MODULES  230
#define  HPE1432_GROUP_INFO_LIST_MODULES  231
#define  HPE1432_GROUP_INFO_NUM_CHANNELS  232
#define  HPE1432_GROUP_INFO_LIST_CHANNELS  233
#define  HPE1432_GROUP_INFO_NUM_INPUTS  234
#define  HPE1432_GROUP_INFO_LIST_INPUTS  235
#define  HPE1432_GROUP_INFO_NUM_SOURCES  236
#define  HPE1432_GROUP_INFO_LIST_SOURCES  237
#define  HPE1432_GROUP_INFO_NUM_TACHS  238
#define  HPE1432_GROUP_INFO_LIST_TACHS  239
#define  HPE1432_GROUP_INFO_SIZE_MAX  500
#define  HPE1432_GROUP_INFO_SIZE_MIN  1


/******   Used by Function hpe1432_getHWConfig   *****/
#define  HPE1432_GET_CONFIG_MAX  255
#define  HPE1432_GET_CONFIG_MIN  1


/******   Used by Function hpe1432_getInputHigh   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInputLow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInputMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInputOffset   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInputOffsetLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInterruptMask   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInterruptPriority   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInterruptPriorityLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getInterruptReason   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */


/******   Used by Function hpe1432_getLbusMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getLbusReset   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMaxOrder   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMaxOrderLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMeasState   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMeasTimeLength   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMeasTimeLengthLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMeasWarning   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MEAS_WARN_BUFFER_MAX  1024
#define  HPE1432_MEAS_WARN_BUFFER_MIN  0


/******   Used by Function hpe1432_getMeasWarningString   *****/
/*  HPE1432_MEAS_WARN_BUFFER_MAX  */
/*  HPE1432_MEAS_WARN_BUFFER_MIN  */
#define  HPE1432_MEAS_WARNING_MAX  9
#define  HPE1432_MEAS_WARNING_MIN  0


/******   Used by Function hpe1432_getMmfDelay   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getMultiSync   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getNextArmRpm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveAvgMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveBlocksize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveHoldMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveIntTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveIntTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveMeas   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveStartFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveStartFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveStopFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveStopFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveTimeConst   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveTimeConstLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveTimeStep   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOctaveTimeStepLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOverlap   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getOverlapLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPeakDecayTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPeakDecayTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPeakMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPreArmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPreArmRpm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getPreArmRpmLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRamp   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRampRate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRampRateLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRange   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRangeCharge   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRangeChargeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRangeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRangeMike   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRangeMikeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRawTachs   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RAW_TACH_BUF_SIZE_MAX  8192
#define  HPE1432_RAW_TACH_BUF_SIZE_MIN  0


/******   Used by Function hpe1432_getRmsAvgTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRmsAvgTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRmsDecayTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRmsDecayTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRmsMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmHigh   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmHighLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmInterval   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmIntervalLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmLow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmLowLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmSmoothing   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getRpmSmoothingLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSampleMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSamplesToPreArm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getScale   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSerialNum   *****/
#define  HPE1432_LA_MAX  255
#define  HPE1432_LA_MIN  0


/******   Used by Function hpe1432_getSineFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSineFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSinePhase   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSinePhaseLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceBlocksize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceBlocksizeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceCenterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceCenterFreqLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceCola   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceOutput   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceSeed   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceSeedLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceSpan   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceSpanLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSourceSum   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSpan   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSpanLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcArbStates   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcBufferInit   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcBufferMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcBufferSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcBufferSizeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSrcParmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getSumbus   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachClockFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachDecimate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachDecimateLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachDelay   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachHoldoff   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachHoldoffLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachIrqNumber   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachIrqNumberLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachMaxTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachMaxTimeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachPpr   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTachPprLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTrigCorr   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerChannel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerDelay   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerDelayLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerExt   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerLevel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TRIGGER_LEVEL_LOWER  416
#define  HPE1432_TRIGGER_LEVEL_UPPER  417


/******   Used by Function hpe1432_getTriggerLevelLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TRIGGER_LEVEL_LOWER  */
/*  HPE1432_TRIGGER_LEVEL_UPPER  */


/******   Used by Function hpe1432_getTriggerMaster   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggerSlope   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggersPerArm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTriggersPerArmLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTtltrgClock   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTtltrgGclock   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTtltrgLines   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTtltrgSatrg   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getTtltrgTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getWeighting   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getWindow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getXferSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getXferSizeLimits   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_getZoom   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_initMeasure   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_initMeasureFinish   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_initMeasureToBooted   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_install   *****/
#define  HPE1432_INSTALL_MAX  15
#define  HPE1432_INSTALL_MIN  1


/******   Used by Function hpe1432_installFile   *****/
#define  HPE1432_INSTALL_FILE  0
#define  HPE1432_INSTALL_MEM  1


/******   Used by Function hpe1432_octaveCtl   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_CTL_STOP  770
#define  HPE1432_OCTAVE_CTL_RESTART  771
#define  HPE1432_OCTAVE_CTL_CONTINUE  772


/******   Used by Function hpe1432_preArmMeasure   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_preset   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_readFloat32Data   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TIME_DATA  345
#define  HPE1432_FREQ_DATA  346
#define  HPE1432_RESAMP_DATA  347
#define  HPE1432_ORDER_DATA  348
#define  HPE1432_REQUEST_DATA  349
/*  HPE1432_OCTAVE_DATA  */
#define  HPE1432_BLOCKSIZE_MAX  16777215
#define  HPE1432_BLOCKSIZE_MIN  1
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_readFloat64Data   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TIME_DATA  */
/*  HPE1432_FREQ_DATA  */
/*  HPE1432_RESAMP_DATA  */
/*  HPE1432_ORDER_DATA  */
/*  HPE1432_REQUEST_DATA  */
/*  HPE1432_OCTAVE_DATA  */
/*  HPE1432_BLOCKSIZE_MAX  */
/*  HPE1432_BLOCKSIZE_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_readI2C   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_I2C_ADDRESS_MAX  255
#define  HPE1432_I2C_ADDRESS_MIN  0


/******   Used by Function hpe1432_readRawData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TIME_DATA  */
/*  HPE1432_FREQ_DATA  */
/*  HPE1432_RESAMP_DATA  */
/*  HPE1432_ORDER_DATA  */
/*  HPE1432_REQUEST_DATA  */
/*  HPE1432_OCTAVE_DATA  */
/*  HPE1432_BLOCKSIZE_MAX  */
/*  HPE1432_BLOCKSIZE_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_readRegister16   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */
#define  HPE1432_REGISTER_MIN  0
#define  HPE1432_REGISTER_MAX  64


/******   Used by Function hpe1432_readRegister32   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */
/*  HPE1432_REGISTER_MIN  */
/*  HPE1432_REGISTER_MAX  */


/******   Used by Function hpe1432_reenableInterrupt   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_resetLbus   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RESET_LBUS_ON  306
#define  HPE1432_RESET_LBUS_OFF  307


/******   Used by Function hpe1432_resetMeasure   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_scaDspDownload   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SCADOWNLOAD_MAX  4096
#define  HPE1432_SCADOWNLOAD_MIN  0


/******   Used by Function hpe1432_scaDspExecQuery   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_EXEC_CMD_MAX  255
#define  HPE1432_EXEC_CMD_MIN  0
#define  HPE1432_EXEC_DATA_SIZE_MAX  224
#define  HPE1432_EXEC_DATA_SIZE_MIN  0
#define  HPE1432_QUERY_DATA_SIZE_MAX  224
#define  HPE1432_QUERY_DATA_SIZE_MIN  0


/******   Used by Function hpe1432_sendTachs   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_RAW_TACH_BUF_SIZE_MAX  */
/*  HPE1432_RAW_TACH_BUF_SIZE_MIN  */


/******   Used by Function hpe1432_sendTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_setActive   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CHANNEL_ON  420
#define  HPE1432_CHANNEL_OFF  421
#define  HPE1432_CHANNEL_MAYBE  422


/******   Used by Function hpe1432_setAmpScale   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AMP_SCALE_MAX  1.0
#define  HPE1432_AMP_SCALE_MIN  0.0


/******   Used by Function hpe1432_setAnalogInput   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_INPUT_MODE_VOLT  130
#define  HPE1432_INPUT_MODE_ICP  131
#define  HPE1432_INPUT_MODE_CHARGE  132
#define  HPE1432_INPUT_MODE_MIC  133
#define  HPE1432_INPUT_HIGH_NORMAL  120
#define  HPE1432_INPUT_HIGH_CALIN  121
#define  HPE1432_INPUT_HIGH_GROUNDED  122
#define  HPE1432_INPUT_HIGH_CALOUT  123
#define  HPE1432_ANTI_ALIAS_ANALOG_ON  112
#define  HPE1432_ANTI_ALIAS_ANALOG_OFF  113
#define  HPE1432_COUPLING_AC  100
#define  HPE1432_COUPLING_DC  101
#define  HPE1432_COUPLING_AC_BOB_HP  102
#define  HPE1432_COUPLING_DC_BOB_HP  103
#define  HPE1432_RANGE_MAX  20.0
#define  HPE1432_RANGE_MIN  0.0


/******   Used by Function hpe1432_setAntiAliasAnalog   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_ANTI_ALIAS_ANALOG_ON  */
/*  HPE1432_ANTI_ALIAS_ANALOG_OFF  */


/******   Used by Function hpe1432_setAntiAliasDigital   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_ANTI_ALIAS_DIGITAL_ON  615
#define  HPE1432_ANTI_ALIAS_DIGITAL_OFF  616
#define  HPE1432_ANTI_ALIAS_DIGITAL_BES  617


/******   Used by Function hpe1432_setAppendStatus   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_APPEND_STATUS_OFF  310
#define  HPE1432_APPEND_STATUS_ON  311


/******   Used by Function hpe1432_setArmChannel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CHANNEL_ON  */
/*  HPE1432_CHANNEL_OFF  */


/******   Used by Function hpe1432_setArmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AUTO_ARM_CONTINUOUS  429
#define  HPE1432_MANUAL_ARM  430
#define  HPE1432_AUTO_ARM  431
#define  HPE1432_ARM_RPM_RUNUP  432
#define  HPE1432_ARM_RPM_RUNDOWN  433
#define  HPE1432_ARM_RPM_DELTA  434
#define  HPE1432_ARM_TIME  436
#define  HPE1432_ARM_TIME_OR_RPM  437


/******   Used by Function hpe1432_setArmTimeInterval   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_ARM_TIME_INTERVAL_MAX  2000000000.0
#define  HPE1432_ARM_TIME_INTERVAL_MIN  0.0001


/******   Used by Function hpe1432_setAutoGroupMeas   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AUTO_GROUP_MEAS_ON  242
#define  HPE1432_AUTO_GROUP_MEAS_OFF  243


/******   Used by Function hpe1432_setAutoRangeMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AUTO_RANGE_MODE_UP  1
#define  HPE1432_AUTO_RANGE_MODE_DOWN  2
#define  HPE1432_AUTO_RANGE_MODE_DEF  3


/******   Used by Function hpe1432_setAutoTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MANUAL_TRIGGER  440
#define  HPE1432_AUTO_TRIGGER  441


/******   Used by Function hpe1432_setAvgMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AVG_NONE  700
#define  HPE1432_AVG_RMS  701
#define  HPE1432_AVG_LIN  702
#define  HPE1432_AVG_EXPO  703
#define  HPE1432_AVG_PEAK  704


/******   Used by Function hpe1432_setAvgNumber   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AVG_NUMBER_MAX  2147483647
#define  HPE1432_AVG_NUMBER_MIN  0


/******   Used by Function hpe1432_setAvgUpdate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AVG_UPDATE_MAX  2147483646
#define  HPE1432_AVG_UPDATE_MIN  1.0


/******   Used by Function hpe1432_setAvgWeight   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_AVG_WEIGHT_MAX  1.0e20
#define  HPE1432_AVG_WEIGHT_MIN  1.0


/******   Used by Function hpe1432_setBlocksize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_BLOCKSIZE_MAX  */
/*  HPE1432_BLOCKSIZE_MIN  */


/******   Used by Function hpe1432_setCalDac   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CAL_DAC_MAX  2048
#define  HPE1432_CAL_DAC_MIN  -2048


/******   Used by Function hpe1432_setCalVoltage   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CAL_VOLTAGE_MAX  15
#define  HPE1432_CAL_VOLTAGE_MIN  -15


/******   Used by Function hpe1432_setCalcData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_DATA_TIME  724
#define  HPE1432_DATA_FREQ  725
#define  HPE1432_DATA_RESAMP_TIME  726
#define  HPE1432_DATA_ORDER  727
#define  HPE1432_DATA_CORR_FREQ  728
#define  HPE1432_DATA_FIR  729
#define  HPE1432_DATA_OCTAVE  730


/******   Used by Function hpe1432_setCalin   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CALIN_OPEN  510
#define  HPE1432_CALIN_GROUND  511
#define  HPE1432_CALIN_DC_HI  512
#define  HPE1432_CALIN_DC_LO  513
#define  HPE1432_CALIN_SUMBUS  514
#define  HPE1432_CALIN_CALOUT  515
#define  HPE1432_CALIN_SUMBUS_TACH  516


/******   Used by Function hpe1432_setCenterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CENTER_FREQ_MAX  128000.0
#define  HPE1432_CENTER_FREQ_MIN  0.0


/******   Used by Function hpe1432_setClockFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CLOCK_FREQ_MAX  200000.0
#define  HPE1432_CLOCK_FREQ_MIN  40960.0


/******   Used by Function hpe1432_setClockMaster   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MASTER_CLOCK_ON  240
#define  HPE1432_MASTER_CLOCK_OFF  241


/******   Used by Function hpe1432_setClockSource   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_CLOCK_VXI_DEC_3  204
#define  HPE1432_CLOCK_SOURCE_EXTERNAL  206
#define  HPE1432_CLOCK_SOURCE_EXTERNALN  207
#define  HPE1432_CLOCK_SOURCE_INTERNAL  208
#define  HPE1432_CLOCK_SOURCE_VXI  209
#define  HPE1432_CLOCK_SOURCE_VXI10  210


/******   Used by Function hpe1432_setCoupling   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_COUPLING_AC  */
/*  HPE1432_COUPLING_DC  */
/*  HPE1432_COUPLING_AC_BOB_HP  */
/*  HPE1432_COUPLING_DC_BOB_HP  */


/******   Used by Function hpe1432_setCouplingFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_COUPLING_FREQ_MAX  100.0
#define  HPE1432_COUPLING_FREQ_MIN  0.0


/******   Used by Function hpe1432_setDataFormat   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_BLOCKSIZE_MAX  */
/*  HPE1432_BLOCKSIZE_MIN  */
#define  HPE1432_DATA_SIZE_16  331
#define  HPE1432_DATA_SIZE_32  332
#define  HPE1432_DATA_SIZE_32_SERV  333
/*  HPE1432_DATA_SIZE_FLOAT32  */
#define  HPE1432_BLOCK_MODE  340
#define  HPE1432_CONTINUOUS_MODE  341
#define  HPE1432_DATA_MODE_OVERLAP_BLOCK  342
#define  HPE1432_DATA_MODE_OVERLAP_FREE  343
/*  HPE1432_APPEND_STATUS_OFF  */
/*  HPE1432_APPEND_STATUS_ON  */


/******   Used by Function hpe1432_setDataMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_BLOCK_MODE  */
/*  HPE1432_CONTINUOUS_MODE  */
/*  HPE1432_DATA_MODE_OVERLAP_BLOCK  */
/*  HPE1432_DATA_MODE_OVERLAP_FREE  */


/******   Used by Function hpe1432_setDataPort   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SEND_PORT_VME  300
#define  HPE1432_SEND_PORT_LBUS  301
#define  HPE1432_SEND_PORT_LBUS_EAVES  302


/******   Used by Function hpe1432_setDataSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_DATA_SIZE_16  */
/*  HPE1432_DATA_SIZE_32  */
/*  HPE1432_DATA_SIZE_32_SERV  */
/*  HPE1432_DATA_SIZE_FLOAT32  */


/******   Used by Function hpe1432_setDecimationOutput   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_ONE_PASS  620
#define  HPE1432_MULTI_PASS  621


/******   Used by Function hpe1432_setDecimationOversample   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_DECIMATION_OVERSAMPLE_OFF  630
#define  HPE1432_DECIMATION_OVERSAMPLE_ON  631


/******   Used by Function hpe1432_setDecimationUndersamp   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_DEC_UNDERSAMP_MAX  16
#define  HPE1432_DEC_UNDERSAMP_MIN  1


/******   Used by Function hpe1432_setDeltaOrder   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_DELTA_ORDER_MAX  1.0
#define  HPE1432_DELTA_ORDER_MIN  0.005


/******   Used by Function hpe1432_setDutyCycle   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_DUTY_CYCLE_MAX  1.0
#define  HPE1432_DUTY_CYCLE_MIN  0.0


/******   Used by Function hpe1432_setEnable   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_ENABLE_TYPE_TIME  */
/*  HPE1432_ENABLE_TYPE_FREQ  */
/*  HPE1432_ENABLE_TYPE_RESAMPLE  */
/*  HPE1432_ENABLE_TYPE_ORDER  */
#define  HPE1432_ENABLE_TYPE_OCTAVE  274
#define  HPE1432_ENABLE_ON  280
#define  HPE1432_ENABLE_OFF  281


/******   Used by Function hpe1432_setFifoSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_FIFO_SIZE_MAX  16777215
#define  HPE1432_FIFO_SIZE_MIN  0


/******   Used by Function hpe1432_setFilterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_FILTER_FREQ_MAX  25600
#define  HPE1432_FILTER_FREQ_MIN  2000


/******   Used by Function hpe1432_setFilterSettlingTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_FILTER_SETTLING_MAX  10000.0
#define  HPE1432_FILTER_SETTLING_MIN  0.0


/******   Used by Function hpe1432_setInputHigh   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_INPUT_HIGH_NORMAL  */
/*  HPE1432_INPUT_HIGH_CALIN  */
/*  HPE1432_INPUT_HIGH_GROUNDED  */
/*  HPE1432_INPUT_HIGH_CALOUT  */
#define  HPE1432_INPUT_HIGH_BOB_CALIN  124


/******   Used by Function hpe1432_setInputLow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_INPUT_LOW_GROUNDED  140
#define  HPE1432_INPUT_LOW_FLOATING  141


/******   Used by Function hpe1432_setInputMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_INPUT_MODE_VOLT  */
/*  HPE1432_INPUT_MODE_ICP  */
/*  HPE1432_INPUT_MODE_CHARGE  */
/*  HPE1432_INPUT_MODE_MIC  */
#define  HPE1432_INPUT_MODE_MIC_200V  134


/******   Used by Function hpe1432_setInputOffset   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_INPUT_OFFSET_MAX  20.0
#define  HPE1432_INPUT_OFFSET_MIN  0.0


/******   Used by Function hpe1432_setInterrupt   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_INT_PRIORITY_LEVEL_MAX  7
#define  HPE1432_INT_PRIORITY_LEVEL_MIN  0
#define  HPE1432_INT_MASK_MAX  65535
#define  HPE1432_INT_MASK_MIN  0


/******   Used by Function hpe1432_setInterruptMask   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_INT_MASK_MAX  */
/*  HPE1432_INT_MASK_MIN  */


/******   Used by Function hpe1432_setInterruptPriority   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_INT_PRIORITY_LEVEL_MAX  */
/*  HPE1432_INT_PRIORITY_LEVEL_MIN  */


/******   Used by Function hpe1432_setLbusMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_LBUS_MODE_GENERATE  302
#define  HPE1432_LBUS_MODE_PIPE  303
#define  HPE1432_LBUS_MODE_INSERT  304
#define  HPE1432_LBUS_MODE_APPEND  305
#define  HPE1432_LBUS_MODE_CONSUME  306


/******   Used by Function hpe1432_setMaxOrder   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MAX_ORDER_MAX  500
#define  HPE1432_MAX_ORDER_MIN  1


/******   Used by Function hpe1432_setMeasTimeLength   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MEAS_TIME_LENGTH_MAX  2000000000.0
#define  HPE1432_MEAS_TIME_LENGTH_MIN  0.0


/******   Used by Function hpe1432_setMmfDelay   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MMF_DELAY_MAX  2147483647
#define  HPE1432_MMF_DELAY_MIN  0


/******   Used by Function hpe1432_setMultiSync   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MULTI_SYNC_ON  220
#define  HPE1432_MULTI_SYNC_OFF  221
#define  HPE1432_MULTI_SYNC_VXD  222
#define  HPE1432_MULTI_SYNC_VXD_MIN  223


/******   Used by Function hpe1432_setOctaveAvgMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_AVG_MODE_EXP  760
#define  HPE1432_OCTAVE_AVG_MODE_LIN  761


/******   Used by Function hpe1432_setOctaveHoldMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_HOLD_MODE_OFF  765
#define  HPE1432_OCTAVE_HOLD_MODE_MAX  766
#define  HPE1432_OCTAVE_HOLD_MODE_MIN  767


/******   Used by Function hpe1432_setOctaveIntTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_INT_TIME_MAX  10000.0
#define  HPE1432_OCTAVE_INT_TIME_MIN  0.001953125


/******   Used by Function hpe1432_setOctaveMeas   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_MEAS_ON  386
#define  HPE1432_OCTAVE_MEAS_OFF  389


/******   Used by Function hpe1432_setOctaveMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_MODE_FULL  751
#define  HPE1432_OCTAVE_MODE_THIRD  752


/******   Used by Function hpe1432_setOctaveStartFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_START_FREQ_MAX  10000.0
#define  HPE1432_OCTAVE_START_FREQ_MIN  3.15


/******   Used by Function hpe1432_setOctaveStopFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_STOP_FREQ_MAX  20000.0
#define  HPE1432_OCTAVE_STOP_FREQ_MIN  3.15


/******   Used by Function hpe1432_setOctaveTimeConst   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_TIME_CONST_MAX  16.0
#define  HPE1432_OCTAVE_TIME_CONST_MIN  0.0078125


/******   Used by Function hpe1432_setOctaveTimeStep   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OCTAVE_TIME_STEP_MAX  10000.0
#define  HPE1432_OCTAVE_TIME_STEP_MIN  0.001953125


/******   Used by Function hpe1432_setOverlap   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_OVERLAP_MAX  16777215
#define  HPE1432_OVERLAP_MIN  -16777215


/******   Used by Function hpe1432_setPeakDecayTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_PEAK_DECAY_TIME_MAX  40.0
#define  HPE1432_PEAK_DECAY_TIME_MIN  0.0


/******   Used by Function hpe1432_setPeakMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_PEAK_MODE_OFF  580
#define  HPE1432_PEAK_MODE_BLOCK  581
#define  HPE1432_PEAK_MODE_FILT  582


/******   Used by Function hpe1432_setPreArmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_MANUAL_ARM  */
/*  HPE1432_AUTO_ARM  */
/*  HPE1432_ARM_RPM_RUNUP  */
/*  HPE1432_ARM_RPM_RUNDOWN  */
/*  HPE1432_ARM_RPM_DELTA  */
#define  HPE1432_ARM_EXTERNAL  435


/******   Used by Function hpe1432_setPreArmRpm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_PREARM_RPM_MAX  300000.0
#define  HPE1432_PREARM_RPM_MIN  0.5


/******   Used by Function hpe1432_setRamp   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RAMP_ON  625
#define  HPE1432_RAMP_OFF  626


/******   Used by Function hpe1432_setRampRate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RAMP_RATE_MAX  100
#define  HPE1432_RAMP_RATE_MIN  0


/******   Used by Function hpe1432_setRange   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_RANGE_MAX  */
/*  HPE1432_RANGE_MIN  */


/******   Used by Function hpe1432_setRangeCharge   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_RANGE_MAX  */
/*  HPE1432_RANGE_MIN  */


/******   Used by Function hpe1432_setRangeMike   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_RANGE_MAX  */
/*  HPE1432_RANGE_MIN  */


/******   Used by Function hpe1432_setRmsAvgTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RMS_AVG_TIME_MAX  60.0
#define  HPE1432_RMS_AVG_TIME_MIN  0.0


/******   Used by Function hpe1432_setRmsDecayTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RMS_DECAY_TIME_MAX  60.0
#define  HPE1432_RMS_DECAY_TIME_MIN  0.0


/******   Used by Function hpe1432_setRmsMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RMS_MODE_OFF  590
#define  HPE1432_RMS_MODE_BLOCK  591
#define  HPE1432_RMS_MODE_FILT  592


/******   Used by Function hpe1432_setRpmHigh   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RPM_HIGH_MAX  300000.0
#define  HPE1432_RPM_HIGH_MIN  0.5


/******   Used by Function hpe1432_setRpmInterval   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RPM_INTERVAL_MAX  300000.0
#define  HPE1432_RPM_INTERVAL_MIN  0.1


/******   Used by Function hpe1432_setRpmLow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RPM_LOW_MAX  300000.0
#define  HPE1432_RPM_LOW_MIN  0.01


/******   Used by Function hpe1432_setRpmSmoothing   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RPM_SMOOTHING_MAX  1.0
#define  HPE1432_RPM_SMOOTHING_MIN  0.0


/******   Used by Function hpe1432_setSampleMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_RESAMP_NORMAL  720
#define  HPE1432_RESAMP_AT_TACH  721


/******   Used by Function hpe1432_setSineFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SINE_FREQ_MAX  25600
#define  HPE1432_SINE_FREQ_MIN  0


/******   Used by Function hpe1432_setSinePhase   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SINE_PHASE_MAX  360.0
#define  HPE1432_SINE_PHASE_MIN  -360.0


/******   Used by Function hpe1432_setSourceBlocksize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_BUFFER_SIZE_MAX  8388608
#define  HPE1432_SOURCE_BUFFER_SIZE_MIN  1


/******   Used by Function hpe1432_setSourceCenterFreq   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_CENTER_FREQ_MAX  12800
#define  HPE1432_SOURCE_CENTER_FREQ_MIN  0


/******   Used by Function hpe1432_setSourceCola   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_COLA_OFF  180
#define  HPE1432_SOURCE_COLA_ON  181


/******   Used by Function hpe1432_setSourceMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_MODE_SINE  170
#define  HPE1432_SOURCE_MODE_BSINE  171
#define  HPE1432_SOURCE_MODE_RAND  172
#define  HPE1432_SOURCE_MODE_BRAND  173
#define  HPE1432_SOURCE_MODE_RANDZ  174
#define  HPE1432_SOURCE_MODE_BRANDZ  175
#define  HPE1432_SOURCE_MODE_ARB  176
#define  HPE1432_SOURCE_MODE_BARB  177


/******   Used by Function hpe1432_setSourceOutput   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_OUTPUT_NORMAL  700
#define  HPE1432_SOURCE_OUTPUT_GROUNDED  701
#define  HPE1432_SOURCE_OUTPUT_OPEN  702
#define  HPE1432_SOURCE_OUTPUT_CAL  703
#define  HPE1432_SOURCE_OUTPUT_MULTI  704


/******   Used by Function hpe1432_setSourceSeed   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_SEED_MAX  255
#define  HPE1432_SOURCE_SEED_MIN  0


/******   Used by Function hpe1432_setSourceSpan   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_SPAN_MAX  25600
#define  HPE1432_SOURCE_SPAN_MIN  0


/******   Used by Function hpe1432_setSourceSum   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SOURCE_SUM_OFF  190
#define  HPE1432_SOURCE_SUM_ON  191


/******   Used by Function hpe1432_setSpan   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SPAN_MAX  78125.0
#define  HPE1432_SPAN_MIN  0.024


/******   Used by Function hpe1432_setSrcBufferInit   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRC_BUFFER_INIT_EMPTY  1
#define  HPE1432_SRC_BUFFER_INIT_RESET  2
#define  HPE1432_SRC_BUFFER_INIT_XFER  3


/******   Used by Function hpe1432_setSrcBufferMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRC_BUFFER_CONTINUOUS  1
#define  HPE1432_SRC_BUFFER_PERIODIC_AB  2
#define  HPE1432_SRC_BUFFER_PERIODIC_A  4
#define  HPE1432_SRC_BUFFER_SWITCHED_AUTO  8
#define  HPE1432_SRC_BUFFER_SWITCHED_CMD  16
#define  HPE1432_SRCBUFFER_ONESHOT  32


/******   Used by Function hpe1432_setSrcBufferSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRC_BUFFER_SIZE_MAX  8388608
#define  HPE1432_SRC_BUFFER_SIZE_MIN  1


/******   Used by Function hpe1432_setSrcParmMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRCPARM_MODE_IMMED  0
#define  HPE1432_SRCPARM_MODE_DEFR  1


/******   Used by Function hpe1432_setSumbus   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SUMBUS_OFF  520
#define  HPE1432_SUMBUS_CALOUT  521


/******   Used by Function hpe1432_setTachDecimate   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TACH_DECIMATE_MAX  65535
#define  HPE1432_TACH_DECIMATE_MIN  0


/******   Used by Function hpe1432_setTachHoldoff   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TACH_HOLDOFF_MAX  0.05
#define  HPE1432_TACH_HOLDOFF_MIN  0.0


/******   Used by Function hpe1432_setTachIrqNumber   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TACH_IRQ_NUMBER_MAX  4096
#define  HPE1432_TACH_IRQ_NUMBER_MIN  1


/******   Used by Function hpe1432_setTachMaxTime   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_MAX_TIME_MAX  20000000000.0
#define  HPE1432_MAX_TIME_MIN  0.0


/******   Used by Function hpe1432_setTachPpr   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TACH_PPR_MAX  65536.0
#define  HPE1432_TACH_PPR_MIN  0.000001


/******   Used by Function hpe1432_setTraceLevel   *****/
#define  HPE1432_TRACE_LEVEL_MAX  999
#define  HPE1432_TRACE_LEVEL_MIN  0


/******   Used by Function hpe1432_setTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CHANNEL_ON  */
/*  HPE1432_CHANNEL_OFF  */
/*  HPE1432_CHANNEL_MAYBE  */
#define  HPE1432_TRIG_DELAY_MAX  16777215
#define  HPE1432_TRIG_DELAY_MIN  -16777215
#define  HPE1432_TRIGGER_LEVEL_MAX  125
#define  HPE1432_TRIGGER_LEVEL_MIN  -125
/*  HPE1432_TRIGGER_LEVEL_MAX  */
/*  HPE1432_TRIGGER_LEVEL_MIN  */
#define  HPE1432_TRIGGER_SLOPE_POS  410
#define  HPE1432_TRIGGER_SLOPE_NEG  411
#define  HPE1432_TRIGGER_MODE_LEVEL  414
#define  HPE1432_TRIGGER_MODE_BOUND  415


/******   Used by Function hpe1432_setTriggerChannel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_CHANNEL_ON  */
/*  HPE1432_CHANNEL_OFF  */
/*  HPE1432_CHANNEL_MAYBE  */
#define  HPE1432_CHANNEL_PRE_ARM  423


/******   Used by Function hpe1432_setTriggerDelay   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TRIG_DELAY_MAX  */
/*  HPE1432_TRIG_DELAY_MIN  */


/******   Used by Function hpe1432_setTriggerExt   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TRIGGER_EXT_OFF  470
#define  HPE1432_TRIGGER_EXT_POS  471
#define  HPE1432_TRIGGER_EXT_NEG  472
#define  HPE1432_TRIGGER_EXT_PREARM_POS  473
#define  HPE1432_TRIGGER_EXT_PREARM_NEG  474


/******   Used by Function hpe1432_setTriggerLevel   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TRIGGER_LEVEL_LOWER  */
/*  HPE1432_TRIGGER_LEVEL_UPPER  */
/*  HPE1432_TRIGGER_LEVEL_MAX  */
/*  HPE1432_TRIGGER_LEVEL_MIN  */


/******   Used by Function hpe1432_setTriggerMaster   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TRIGGER_MASTER_OFF  450
#define  HPE1432_TRIGGER_SLAVE  451
#define  HPE1432_TRIGGER_MASTER_ON  452


/******   Used by Function hpe1432_setTriggerMode   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TRIGGER_MODE_LEVEL  */
/*  HPE1432_TRIGGER_MODE_BOUND  */


/******   Used by Function hpe1432_setTriggerSlope   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TRIGGER_SLOPE_POS  */
/*  HPE1432_TRIGGER_SLOPE_NEG  */


/******   Used by Function hpe1432_setTriggersPerArm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TRIGGERS_PER_ARM_MAX  2147483647
#define  HPE1432_TRIGGERS_PER_ARM_MIN  0


/******   Used by Function hpe1432_setTtltrgClock   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_TTLTRG_0  261
#define  HPE1432_TTLTRG_1  262
#define  HPE1432_TTLTRG_2  263
#define  HPE1432_TTLTRG_3  264
#define  HPE1432_TTLTRG_4  265
#define  HPE1432_TTLTRG_5  266
#define  HPE1432_TTLTRG_6  267
#define  HPE1432_TTLTRG_7  268


/******   Used by Function hpe1432_setTtltrgGclock   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TTLTRG_0  */
/*  HPE1432_TTLTRG_1  */
/*  HPE1432_TTLTRG_2  */
/*  HPE1432_TTLTRG_3  */
/*  HPE1432_TTLTRG_4  */
/*  HPE1432_TTLTRG_5  */
/*  HPE1432_TTLTRG_6  */
/*  HPE1432_TTLTRG_7  */


/******   Used by Function hpe1432_setTtltrgLines   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TTLTRG_0  */
/*  HPE1432_TTLTRG_1  */
/*  HPE1432_TTLTRG_2  */
/*  HPE1432_TTLTRG_3  */
/*  HPE1432_TTLTRG_4  */
/*  HPE1432_TTLTRG_5  */
/*  HPE1432_TTLTRG_6  */
/*  HPE1432_TTLTRG_7  */


/******   Used by Function hpe1432_setTtltrgSatrg   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TTLTRG_0  */
/*  HPE1432_TTLTRG_1  */
/*  HPE1432_TTLTRG_2  */
/*  HPE1432_TTLTRG_3  */
/*  HPE1432_TTLTRG_4  */
/*  HPE1432_TTLTRG_5  */
/*  HPE1432_TTLTRG_6  */
/*  HPE1432_TTLTRG_7  */


/******   Used by Function hpe1432_setTtltrgTrigger   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_TTLTRG_0  */
/*  HPE1432_TTLTRG_1  */
/*  HPE1432_TTLTRG_2  */
/*  HPE1432_TTLTRG_3  */
/*  HPE1432_TTLTRG_4  */
/*  HPE1432_TTLTRG_5  */
/*  HPE1432_TTLTRG_6  */
/*  HPE1432_TTLTRG_7  */


/******   Used by Function hpe1432_setUserData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_UD_FRAME_MAX  2147483647
#define  HPE1432_UD_FRAME_MIN  0
#define  HPE1432_UD_WORD_MAX  2147483647
#define  HPE1432_UD_WORD_MIN  0
#define  HPE1432_UD_SUBLEN_MAX  2147483647
#define  HPE1432_UD_SUBLEN_MIN  0
#define  HPE1432_UD_SUBPOS_MAX  2147483647
#define  HPE1432_UD_SUBPOS_MIN  0


/******   Used by Function hpe1432_setUserWindow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_WINDOW_SCALE_MAX  1000000.0
#define  HPE1432_WINDOW_SCALE_MIN  0.0


/******   Used by Function hpe1432_setWeighting   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_WEIGHTING_OFF  105
#define  HPE1432_WEIGHTING_A  106
#define  HPE1432_WEIGHTING_B  107
#define  HPE1432_WEIGHTING_C  108


/******   Used by Function hpe1432_setWindow   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_WINDOW_UNIFORM  710
#define  HPE1432_WINDOW_HANNING  711
#define  HPE1432_WINDOW_FLATTOP  712
#define  HPE1432_WINDOW_USER  713


/******   Used by Function hpe1432_setXferSize   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_XFER_SIZE_MAX  16777215
#define  HPE1432_XFER_SIZE_MIN  0


/******   Used by Function hpe1432_setZoom   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_ZOOM_ON  622
#define  HPE1432_ZOOM_OFF  623


/******   Used by Function hpe1432_srcGetFwrev   *****/
#define  HPE1432_SRC_NUMWORDS_MAX  33554432
#define  HPE1432_SRC_NUMWORDS_MIN  0


/******   Used by Function hpe1432_srcGetRev   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */


/******   Used by Function hpe1432_srcProgRomImage   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_SRC_NUMWORDS_MAX  */
/*  HPE1432_SRC_NUMWORDS_MIN  */


/******   Used by Function hpe1432_srcRxfr   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_SRC_NUMWORDS_MAX  */
/*  HPE1432_SRC_NUMWORDS_MIN  */
#define  HPE1432_SRC_DATA_MODE_A  1
#define  HPE1432_SRC_DATA_MODE_B  2
#define  HPE1432_SRC_DATA_MODE_AB  3
/*  HPE1432_SRC_DATA_MODE_WAITA  */
/*  HPE1432_SRC_DATA_MODE_WAITB  */
/*  HPE1432_SRC_DATA_MODE_WAITAB  */
#define  HPE1432_SRC_DATA_MODE_RESETA  7
#define  HPE1432_SRC_DATA_MODE_RESETB  8


/******   Used by Function hpe1432_triggerMeasure   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_NO_WAIT_FLAG  */
/*  HPE1432_WAIT_FLAG  */


/******   Used by Function hpe1432_updateSrcParm   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRCPARM_UPDATE_IMMED  0
#define  HPE1432_SRCPARM_UPDATE_XING  1
#define  HPE1432_SRCPARM_UPDATE_TRGIN  2
#define  HPE1432_SRCPARM_UPDATE_IMMEDTRGOUT  3
#define  HPE1432_SRCPARM_UPDATE_XINGTRGOUT  4
#define  HPE1432_SRCPARM_UPDATE_TRGINTRGOUT  5


/******   Used by Function hpe1432_writeI2C   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
/*  HPE1432_I2C_ADDRESS_MAX  */
/*  HPE1432_I2C_ADDRESS_MIN  */
#define  HPE1432_I2C_MAX  255
#define  HPE1432_I2C_MIN  0


/******   Used by Function hpe1432_writeRegister16   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */
/*  HPE1432_REGISTER_MIN  */
/*  HPE1432_REGISTER_MAX  */
#define  HPE1432_MIN_16  -32768
#define  HPE1432_MAX_16  32767


/******   Used by Function hpe1432_writeRegister32   *****/
/*  HPE1432_CHANNEL_ID_MAX  */
/*  HPE1432_CHANNEL_ID_MIN  */
/*  HPE1432_REGISTER_MIN  */
/*  HPE1432_REGISTER_MAX  */
#define  HPE1432_MAX_32  2147483647
#define  HPE1432_MIN_32  (-2147483647 -1)


/******   Used by Function hpe1432_writeSrcBufferData   *****/
/*  HPE1432_GROUP_ID_MAX  */
/*  HPE1432_GROUP_ID_MIN  */
#define  HPE1432_SRC_DATA_NUMWORDS_MAX  4096
#define  HPE1432_SRC_DATA_NUMWORDS_MIN  1
/*  HPE1432_SRC_DATA_MODE_A  */
/*  HPE1432_SRC_DATA_MODE_B  */
/*  HPE1432_SRC_DATA_MODE_AB  */
/*  HPE1432_SRC_DATA_MODE_WAITA  */
/*  HPE1432_SRC_DATA_MODE_WAITB  */
/*  HPE1432_SRC_DATA_MODE_WAITAB  */
/*  HPE1432_SRC_DATA_MODE_RESETA  */
/*  HPE1432_SRC_DATA_MODE_RESETB  */

ViStatus _VI_FUNC hpe1432_armMeasure  (ViSession vi, ViInt32 group, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_armMeasureMasterFinish  (ViSession vi, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_armMeasureMasterSetup  (ViSession vi, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_armMeasureSlaveFinish  (ViSession vi, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_arrayControl  (ViSession vi, ViInt32 numChans, ViReal64 darray[]);

ViStatus _VI_FUNC hpe1432_arrayNextChan  (ViSession vi, ViPInt32 chan);

ViStatus _VI_FUNC hpe1432_arrayReadChan  (ViSession vi, ViPInt32 chan, ViReal64 data[]);

ViStatus _VI_FUNC hpe1432_autoRange  (ViSession vi, ViInt32 group, ViReal64 autoRangeTime);

ViStatus _VI_FUNC hpe1432_autoZero  (ViSession vi, ViInt32 group);

ViStatus _VI_FUNC hpe1432_blockAvailable  (ViSession vi, ViInt32 group, ViPInt32 blockAvailable);

ViStatus _VI_FUNC hpe1432_cachedParmUpdate  (ViSession vi, ViInt32 group);

#ifdef INSTR_CALLBACKS
ViStatus _VI_FUNC hpe1432_callbackInstall  (ViSession vi, ViInt32 channel, hpe1432_callbackFunc cbFunc, ViInt32 mask);

#endif /* INSTR_CALLBACKS */
ViStatus _VI_FUNC hpe1432_channelGroupAdd  (ViSession vi, ViInt32 group, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_channelGroupRemove  (ViSession vi, ViInt32 group, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_checkOverloads  (ViSession vi, ViInt32 group, ViPInt16 anyOver, ViInt16 common[], ViInt16 diff[], ViInt16 half[]);

ViStatus _VI_FUNC hpe1432_checkSrcArbRdy  (ViSession vi, ViInt32 chan, ViInt32 mode, ViPInt32 srcArbRdy);

ViStatus _VI_FUNC hpe1432_checkSrcOverload  (ViSession vi, ViInt32 group, ViPInt32 srcOverload);

ViStatus _VI_FUNC hpe1432_checkSrcOverread  (ViSession vi, ViInt32 group, ViPInt32 srcOverread);

ViStatus _VI_FUNC hpe1432_checkSrcShutdown  (ViSession vi, ViInt32 group, ViPInt32 srcShutdown);

ViStatus _VI_FUNC hpe1432_checkSrcUnderrun  (ViSession vi, ViInt32 group, ViPInt32 srcUnderrun);

ViStatus _VI_FUNC hpe1432_close  (ViSession vi);

ViStatus _VI_FUNC hpe1432_createChannelGroup  (ViSession vi, ViInt32 num, ViInt32 channels[], ViPInt32 groupID);

ViStatus _VI_FUNC hpe1432_deleteAllChanGroups  (ViSession vi);

ViStatus _VI_FUNC hpe1432_deleteChannelGroup  (ViSession vi, ViInt32 group);

ViStatus _VI_FUNC hpe1432_errorDetails  (ViSession vi, ViChar error[], ViInt32 maxLen);

ViStatus _VI_FUNC hpe1432_errorDetails2  (ViSession vi, ViChar error[], ViInt32 maxLen, ViPInt32 actual);

ViStatus _VI_FUNC hpe1432_error_message  (ViSession vi, ViStatus error, ViChar _VI_FAR message[]);

ViStatus _VI_FUNC hpe1432_error_query  (ViSession vi, ViPInt32 error, ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC hpe1432_find  (ViSession vi, ViInt32 addList[], ViInt32 listSize, ViPInt32 numFound, ViChar rsrc[], ViInt32 rsrcLen);

ViStatus _VI_FUNC hpe1432_finishMeasure  (ViSession vi, ViInt32 group);

ViStatus _VI_FUNC hpe1432_getActive  (ViSession vi, ViInt32 group, ViPInt32 active);

ViStatus _VI_FUNC hpe1432_getAmpScale  (ViSession vi, ViInt32 group, ViPReal64 ampScale);

ViStatus _VI_FUNC hpe1432_getAmpScaleLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getAntiAliasAnalog  (ViSession vi, ViInt32 group, ViPInt32 antiAnalog);

ViStatus _VI_FUNC hpe1432_getAntiAliasDigital  (ViSession vi, ViInt32 group, ViPInt32 antiDigital);

ViStatus _VI_FUNC hpe1432_getAppendStatus  (ViSession vi, ViInt32 group, ViPInt32 status);

ViStatus _VI_FUNC hpe1432_getArmChannel  (ViSession vi, ViInt32 group, ViPInt32 active);

ViStatus _VI_FUNC hpe1432_getArmMode  (ViSession vi, ViInt32 group, ViPInt32 armMode);

ViStatus _VI_FUNC hpe1432_getArmTimeInterval  (ViSession vi, ViInt32 group, ViPReal64 armTimeInt);

ViStatus _VI_FUNC hpe1432_getArmTimeIntervalLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getAutoGroupMeas  (ViSession vi, ViInt32 group, ViPInt32 autoGroupMeas);

ViStatus _VI_FUNC hpe1432_getAutoRangeMode  (ViSession vi, ViInt32 group, ViPInt32 arMode);

ViStatus _VI_FUNC hpe1432_getAutoTrigger  (ViSession vi, ViInt32 group, ViPInt32 autoTrigger);

ViStatus _VI_FUNC hpe1432_getAvgMode  (ViSession vi, ViInt32 group, ViPInt32 avgMode);

ViStatus _VI_FUNC hpe1432_getAvgNumber  (ViSession vi, ViInt32 group, ViPInt32 avgNum);

ViStatus _VI_FUNC hpe1432_getAvgNumberLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getAvgUpdate  (ViSession vi, ViInt32 group, ViPInt32 avgUp);

ViStatus _VI_FUNC hpe1432_getAvgUpdateLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getAvgWeight  (ViSession vi, ViInt32 group, ViPReal64 avgWt);

ViStatus _VI_FUNC hpe1432_getAvgWeightLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getBlocksize  (ViSession vi, ViInt32 group, ViPInt32 blocksize);

ViStatus _VI_FUNC hpe1432_getBlocksizeCurrentMax  (ViSession vi, ViInt32 group, ViPInt32 blocksizeMax);

ViStatus _VI_FUNC hpe1432_getBlocksizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getCalDac  (ViSession vi, ViInt32 group, ViPInt32 calDac);

ViStatus _VI_FUNC hpe1432_getCalDacLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getCalVoltage  (ViSession vi, ViInt32 group, ViPReal64 calVolts);

ViStatus _VI_FUNC hpe1432_getCalVoltageLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getCalcData  (ViSession vi, ViInt32 group, ViPInt32 calcData);

ViStatus _VI_FUNC hpe1432_getCalin  (ViSession vi, ViInt32 group, ViPInt32 calInStatus);

ViStatus _VI_FUNC hpe1432_getCenterFreq  (ViSession vi, ViInt32 group, ViPReal64 centerFreq);

ViStatus _VI_FUNC hpe1432_getCenterFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getClockFreq  (ViSession vi, ViInt32 group, ViPReal64 clockFreq);

ViStatus _VI_FUNC hpe1432_getClockFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getClockMaster  (ViSession vi, ViInt32 group, ViPInt32 clockMasterStatus);

ViStatus _VI_FUNC hpe1432_getClockSource  (ViSession vi, ViInt32 group, ViPInt32 clockSource);

ViStatus _VI_FUNC hpe1432_getCoupling  (ViSession vi, ViInt32 group, ViPInt32 coupling);

ViStatus _VI_FUNC hpe1432_getCouplingFreq  (ViSession vi, ViInt32 group, ViPReal64 couplingFreq);

ViStatus _VI_FUNC hpe1432_getCouplingFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getCurrentData  (ViSession vi, ViInt32 group, ViInt32 datatype, ViInt32 datasize, ViChar data[], ViPInt32 actualCnt);

ViStatus _VI_FUNC hpe1432_getCurrentRpm  (ViSession vi, ViInt32 group, ViPReal64 currentRpm);

ViStatus _VI_FUNC hpe1432_getCurrentValue  (ViSession vi, ViInt32 channel, ViInt32 valueType, ViPReal64 curVal);

#ifdef INSTR_REAL32
ViStatus _VI_FUNC hpe1432_getCurrentValue32  (ViSession vi, ViInt32 group, ViInt32 valueType, ViPReal32 curVal);

#endif /* INSTR_REAL32 */
ViStatus _VI_FUNC hpe1432_getDataMode  (ViSession vi, ViInt32 group, ViPInt32 dataMode);

ViStatus _VI_FUNC hpe1432_getDataPort  (ViSession vi, ViInt32 group, ViPInt32 dataPort);

ViStatus _VI_FUNC hpe1432_getDataRpm  (ViSession vi, ViInt32 group, ViPReal64 currentRpm);

ViStatus _VI_FUNC hpe1432_getDataSize  (ViSession vi, ViInt32 group, ViPInt32 dataSize);

ViStatus _VI_FUNC hpe1432_getDecimation  (ViSession vi, ViInt32 group, ViPInt32 dec);

ViStatus _VI_FUNC hpe1432_getDecimationOutput  (ViSession vi, ViInt32 group, ViPInt32 decOut);

ViStatus _VI_FUNC hpe1432_getDecimationOversample  (ViSession vi, ViInt32 group, ViPInt32 decOversamp);

ViStatus _VI_FUNC hpe1432_getDecimationUndersamp  (ViSession vi, ViInt32 group, ViPInt32 undersamp);

ViStatus _VI_FUNC hpe1432_getDecimationUndersampLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getDeltaOrder  (ViSession vi, ViInt32 group, ViPReal64 delOrder);

ViStatus _VI_FUNC hpe1432_getDeltaOrderLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getDutyCycle  (ViSession vi, ViInt32 group, ViPReal64 dutyCycle);

ViStatus _VI_FUNC hpe1432_getDutyCycleLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getEnable  (ViSession vi, ViInt32 group, ViInt32 dataType, ViPInt32 enable);

ViStatus _VI_FUNC hpe1432_getFifoSize  (ViSession vi, ViInt32 group, ViPInt32 fifoSize);

ViStatus _VI_FUNC hpe1432_getFifoSizeCurrentMax  (ViSession vi, ViInt32 group, ViPInt32 maxSize);

ViStatus _VI_FUNC hpe1432_getFifoSizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getFilterFreq  (ViSession vi, ViInt32 group, ViPReal64 filterFreq);

ViStatus _VI_FUNC hpe1432_getFilterFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getFilterSettlingTime  (ViSession vi, ViInt32 group, ViPReal64 filtSetTime);

ViStatus _VI_FUNC hpe1432_getFilterSettlingTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getFwrev  (ViSession vi, ViChar path[], ViPInt32 fwrev);

ViStatus _VI_FUNC hpe1432_getGroupInfo  (ViSession vi, ViInt32 group, ViInt32 item, ViPInt32 answer, ViInt32 size);

ViStatus _VI_FUNC hpe1432_getHWConfig  (ViSession vi, ViInt32 modCount, ViInt32 address[], ViInt32 configInfo[]);

ViStatus _VI_FUNC hpe1432_getInputHigh  (ViSession vi, ViInt32 group, ViPInt32 inputHigh);

ViStatus _VI_FUNC hpe1432_getInputLow  (ViSession vi, ViInt32 group, ViPInt32 inputLow);

ViStatus _VI_FUNC hpe1432_getInputMode  (ViSession vi, ViInt32 group, ViPInt32 inputMode);

ViStatus _VI_FUNC hpe1432_getInputOffset  (ViSession vi, ViInt32 group, ViPReal64 inputOffset);

ViStatus _VI_FUNC hpe1432_getInputOffsetLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getInterruptMask  (ViSession vi, ViInt32 group, ViPInt32 intMask);

ViStatus _VI_FUNC hpe1432_getInterruptPriority  (ViSession vi, ViInt32 group, ViPInt32 priority);

ViStatus _VI_FUNC hpe1432_getInterruptPriorityLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getInterruptReason  (ViSession vi, ViInt32 channel, ViPInt32 reason);

ViStatus _VI_FUNC hpe1432_getLbusMode  (ViSession vi, ViInt32 group, ViPInt32 lbusMode);

ViStatus _VI_FUNC hpe1432_getLbusReset  (ViSession vi, ViInt32 group, ViPInt32 lbusReset);

ViStatus _VI_FUNC hpe1432_getMaxOrder  (ViSession vi, ViInt32 group, ViPReal64 maxOrder);

ViStatus _VI_FUNC hpe1432_getMaxOrderLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getMeasState  (ViSession vi, ViInt32 group, ViPInt32 measState);

ViStatus _VI_FUNC hpe1432_getMeasTimeLength  (ViSession vi, ViInt32 group, ViPReal64 measTime);

ViStatus _VI_FUNC hpe1432_getMeasTimeLengthLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getMeasWarning  (ViSession vi, ViInt32 group, ViInt16 warnings[], ViInt32 bufferSize, ViPInt32 count);

ViStatus _VI_FUNC hpe1432_getMeasWarningString  (ViSession vi, ViChar warningString[], ViInt32 bufferSize, ViInt32 warning);

ViStatus _VI_FUNC hpe1432_getMmfDelay  (ViSession vi, ViInt32 group, ViPInt32 mmfdelay);

ViStatus _VI_FUNC hpe1432_getMultiSync  (ViSession vi, ViInt32 group, ViPInt32 multiSync);

ViStatus _VI_FUNC hpe1432_getNextArmRpm  (ViSession vi, ViInt32 group, ViPReal64 nextArmRpm);

ViStatus _VI_FUNC hpe1432_getNumChans  (ViSession vi, ViPInt32 totalChans, ViPInt32 numInputs, ViPInt32 numSources, ViPInt32 numTachs);

ViStatus _VI_FUNC hpe1432_getOctaveAvgMode  (ViSession vi, ViInt32 group, ViPInt32 octAvgMode);

ViStatus _VI_FUNC hpe1432_getOctaveBlocksize  (ViSession vi, ViInt32 group, ViPInt32 octBlkSize);

ViStatus _VI_FUNC hpe1432_getOctaveHoldMode  (ViSession vi, ViInt32 group, ViPInt32 octHoldMode);

ViStatus _VI_FUNC hpe1432_getOctaveIntTime  (ViSession vi, ViInt32 group, ViPReal64 octIntTime);

ViStatus _VI_FUNC hpe1432_getOctaveIntTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getOctaveMeas  (ViSession vi, ViInt32 group, ViPInt32 octMeas);

ViStatus _VI_FUNC hpe1432_getOctaveMode  (ViSession vi, ViInt32 group, ViPInt32 octaveMode);

ViStatus _VI_FUNC hpe1432_getOctaveStartFreq  (ViSession vi, ViInt32 group, ViPReal64 octStartFreq);

ViStatus _VI_FUNC hpe1432_getOctaveStartFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getOctaveStopFreq  (ViSession vi, ViInt32 group, ViPReal64 octStopFreq);

ViStatus _VI_FUNC hpe1432_getOctaveStopFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getOctaveTimeConst  (ViSession vi, ViInt32 group, ViPReal64 octTimeConst);

ViStatus _VI_FUNC hpe1432_getOctaveTimeConstLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getOctaveTimeStep  (ViSession vi, ViInt32 group, ViPReal64 octTimeStep);

ViStatus _VI_FUNC hpe1432_getOctaveTimeStepLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getOverlap  (ViSession vi, ViInt32 group, ViPInt32 overlap);

ViStatus _VI_FUNC hpe1432_getOverlapLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getPeakDecayTime  (ViSession vi, ViInt32 group, ViPReal64 peakDecayTime);

ViStatus _VI_FUNC hpe1432_getPeakDecayTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getPeakMode  (ViSession vi, ViInt32 group, ViPInt32 peakMode);

ViStatus _VI_FUNC hpe1432_getPreArmMode  (ViSession vi, ViInt32 group, ViPInt32 preArmMode);

ViStatus _VI_FUNC hpe1432_getPreArmRpm  (ViSession vi, ViInt32 group, ViPReal64 preArmRpm);

ViStatus _VI_FUNC hpe1432_getPreArmRpmLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRamp  (ViSession vi, ViInt32 group, ViPInt32 ramp);

ViStatus _VI_FUNC hpe1432_getRampRate  (ViSession vi, ViInt32 group, ViPReal64 rampRate);

ViStatus _VI_FUNC hpe1432_getRampRateLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRange  (ViSession vi, ViInt32 group, ViPReal64 range);

ViStatus _VI_FUNC hpe1432_getRangeCharge  (ViSession vi, ViInt32 group, ViPReal64 range);

ViStatus _VI_FUNC hpe1432_getRangeChargeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRangeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRangeMike  (ViSession vi, ViInt32 group, ViPReal64 range);

ViStatus _VI_FUNC hpe1432_getRangeMikeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRawTachs  (ViSession vi, ViInt32 group, ViInt32 buffer[], ViInt32 size, ViPInt32 actualCnt);

ViStatus _VI_FUNC hpe1432_getRmsAvgTime  (ViSession vi, ViInt32 group, ViPReal64 rmsAvgTime);

ViStatus _VI_FUNC hpe1432_getRmsAvgTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRmsDecayTime  (ViSession vi, ViInt32 group, ViPReal64 decayTime);

ViStatus _VI_FUNC hpe1432_getRmsDecayTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRmsMode  (ViSession vi, ViInt32 group, ViPInt32 rmsMode);

ViStatus _VI_FUNC hpe1432_getRpmHigh  (ViSession vi, ViInt32 group, ViPReal64 rpmHigh);

ViStatus _VI_FUNC hpe1432_getRpmHighLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRpmInterval  (ViSession vi, ViInt32 group, ViPReal64 rpmInt);

ViStatus _VI_FUNC hpe1432_getRpmIntervalLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRpmLow  (ViSession vi, ViInt32 group, ViPReal64 rpmLow);

ViStatus _VI_FUNC hpe1432_getRpmLowLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getRpmSmoothing  (ViSession vi, ViInt32 group, ViPReal64 rpmSmooth);

ViStatus _VI_FUNC hpe1432_getRpmSmoothingLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSampleMode  (ViSession vi, ViInt32 group, ViPInt32 sampleMode);

ViStatus _VI_FUNC hpe1432_getSamplesToPreArm  (ViSession vi, ViInt32 group, ViPInt32 samples);

ViStatus _VI_FUNC hpe1432_getScale  (ViSession vi, ViInt32 group, ViPReal64 scaleFactor);

ViStatus _VI_FUNC hpe1432_getSerialNum  (ViSession vi, ViInt32 la, ViChar serial[]);

ViStatus _VI_FUNC hpe1432_getSineFreq  (ViSession vi, ViInt32 group, ViPReal64 sineFreq);

ViStatus _VI_FUNC hpe1432_getSineFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSinePhase  (ViSession vi, ViInt32 group, ViPReal64 sinePhase);

ViStatus _VI_FUNC hpe1432_getSinePhaseLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSourceBlocksize  (ViSession vi, ViInt32 group, ViPInt32 srcBlocksize);

ViStatus _VI_FUNC hpe1432_getSourceBlocksizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSourceCenterFreq  (ViSession vi, ViInt32 group, ViPReal64 srcCenterFreq);

ViStatus _VI_FUNC hpe1432_getSourceCenterFreqLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSourceCola  (ViSession vi, ViInt32 group, ViPInt32 srcCola);

ViStatus _VI_FUNC hpe1432_getSourceMode  (ViSession vi, ViInt32 group, ViPInt32 srcMode);

ViStatus _VI_FUNC hpe1432_getSourceOutput  (ViSession vi, ViInt32 group, ViPInt32 srcOutput);

ViStatus _VI_FUNC hpe1432_getSourceSeed  (ViSession vi, ViInt32 group, ViPInt32 srcSeed);

ViStatus _VI_FUNC hpe1432_getSourceSeedLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSourceSpan  (ViSession vi, ViInt32 group, ViPReal64 srcSpan);

ViStatus _VI_FUNC hpe1432_getSourceSpanLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSourceSum  (ViSession vi, ViInt32 group, ViPInt32 srcSum);

ViStatus _VI_FUNC hpe1432_getSpan  (ViSession vi, ViInt32 group, ViPReal64 span);

ViStatus _VI_FUNC hpe1432_getSpanLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSrcArbStates  (ViSession vi, ViInt32 chan, ViPInt32 xfrBufWds, ViPInt32 srcBufStateAB, ViPInt32 srcBufStateA, ViPInt32 srcBufStateB);

ViStatus _VI_FUNC hpe1432_getSrcBufferInit  (ViSession vi, ViInt32 group, ViPInt32 srcBufInit);

ViStatus _VI_FUNC hpe1432_getSrcBufferMode  (ViSession vi, ViInt32 group, ViPInt32 srcBufMode);

ViStatus _VI_FUNC hpe1432_getSrcBufferSize  (ViSession vi, ViInt32 group, ViPInt32 srcBufSize);

ViStatus _VI_FUNC hpe1432_getSrcBufferSizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getSrcParmMode  (ViSession vi, ViInt32 group, ViPInt32 srcParmMode);

ViStatus _VI_FUNC hpe1432_getSumbus  (ViSession vi, ViInt32 group, ViPInt32 sumbus);

ViStatus _VI_FUNC hpe1432_getTachClockFreq  (ViSession vi, ViInt32 group, ViPReal64 tachClockFreq);

ViStatus _VI_FUNC hpe1432_getTachDecimate  (ViSession vi, ViInt32 group, ViPInt32 tachDec);

ViStatus _VI_FUNC hpe1432_getTachDecimateLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTachDelay  (ViSession vi, ViInt32 group, ViPReal64 tachDelay);

ViStatus _VI_FUNC hpe1432_getTachHoldoff  (ViSession vi, ViInt32 group, ViPReal64 tachHoldoff);

ViStatus _VI_FUNC hpe1432_getTachHoldoffLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTachIrqNumber  (ViSession vi, ViInt32 group, ViPInt32 irqNum);

ViStatus _VI_FUNC hpe1432_getTachIrqNumberLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTachMaxTime  (ViSession vi, ViInt32 group, ViPReal64 tachMaxTime);

ViStatus _VI_FUNC hpe1432_getTachMaxTimeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTachPpr  (ViSession vi, ViInt32 group, ViPReal64 tachPpr);

ViStatus _VI_FUNC hpe1432_getTachPprLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTrigCorr  (ViSession vi, ViInt32 group, ViPReal64 trigcorr);

ViStatus _VI_FUNC hpe1432_getTriggerChannel  (ViSession vi, ViInt32 group, ViPInt32 trigChan);

ViStatus _VI_FUNC hpe1432_getTriggerDelay  (ViSession vi, ViInt32 group, ViPInt32 trigDelay);

ViStatus _VI_FUNC hpe1432_getTriggerDelayLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTriggerExt  (ViSession vi, ViInt32 group, ViPInt32 trigExt);

ViStatus _VI_FUNC hpe1432_getTriggerLevel  (ViSession vi, ViInt32 group, ViInt32 selectLevel, ViPReal64 trigLevel);

ViStatus _VI_FUNC hpe1432_getTriggerLevelLimits  (ViSession vi, ViInt32 group, ViInt32 selectLevel, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTriggerMaster  (ViSession vi, ViInt32 group, ViPInt32 trigMaster);

ViStatus _VI_FUNC hpe1432_getTriggerMode  (ViSession vi, ViInt32 group, ViPInt32 trigMode);

ViStatus _VI_FUNC hpe1432_getTriggerSlope  (ViSession vi, ViInt32 group, ViPInt32 trigSlope);

ViStatus _VI_FUNC hpe1432_getTriggersPerArm  (ViSession vi, ViInt32 group, ViPInt32 trigsPerArm);

ViStatus _VI_FUNC hpe1432_getTriggersPerArmLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getTtltrgClock  (ViSession vi, ViInt32 group, ViPInt32 ttlClock);

ViStatus _VI_FUNC hpe1432_getTtltrgGclock  (ViSession vi, ViInt32 group, ViPInt32 ttltrgGClock);

ViStatus _VI_FUNC hpe1432_getTtltrgLines  (ViSession vi, ViInt32 group, ViPInt32 ttltrgLines);

ViStatus _VI_FUNC hpe1432_getTtltrgSatrg  (ViSession vi, ViInt32 group, ViPInt32 ttltrgSatrg);

ViStatus _VI_FUNC hpe1432_getTtltrgTrigger  (ViSession vi, ViInt32 group, ViPInt32 ttltrgTrig);

ViStatus _VI_FUNC hpe1432_getWeighting  (ViSession vi, ViInt32 group, ViPInt32 weight);

ViStatus _VI_FUNC hpe1432_getWindow  (ViSession vi, ViInt32 group, ViPInt32 window);

ViStatus _VI_FUNC hpe1432_getXferSize  (ViSession vi, ViInt32 group, ViPInt32 xferSize);

ViStatus _VI_FUNC hpe1432_getXferSizeLimits  (ViSession vi, ViInt32 group, ViPReal64 min, ViPReal64 max, ViPReal64 def, ViPReal64 step);

ViStatus _VI_FUNC hpe1432_getZoom  (ViSession vi, ViInt32 group, ViPInt32 zoom);

ViStatus _VI_FUNC hpe1432_init  (ViRsrc rsrcName, ViBoolean id_query, ViBoolean reset, ViPSession vi);

ViStatus _VI_FUNC hpe1432_initMeasure  (ViSession vi, ViInt32 id);

ViStatus _VI_FUNC hpe1432_initMeasureFinish  (ViSession vi, ViInt32 group, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_initMeasureToBooted  (ViSession vi, ViInt32 group, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_install  (ViSession vi, ViInt32 numMods, ViInt32 logAddrs[], ViString file);

ViStatus _VI_FUNC hpe1432_installFile  (ViSession vi, ViString loc, ViInt32 fromMem);

ViStatus _VI_FUNC hpe1432_octaveCtl  (ViSession vi, ViInt32 group, ViInt32 octCtl);

ViStatus _VI_FUNC hpe1432_preArmMeasure  (ViSession vi, ViInt32 group, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_preset  (ViSession vi, ViInt32 group);

#ifdef INSTR_REAL32
ViStatus _VI_FUNC hpe1432_readFloat32Data  (ViSession vi, ViInt32 group, ViInt32 which, ViReal32 data[], ViInt32 size, ViPInt32 actualCnt, ViInt32 wait);

#endif /* INSTR_REAL32 */
ViStatus _VI_FUNC hpe1432_readFloat64Data  (ViSession vi, ViInt32 group, ViInt32 which, ViReal64 data[], ViInt32 size, ViPInt32 actualCnt, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_readI2C  (ViSession vi, ViInt32 group, ViInt32 address, ViPInt32 i2cdata);

ViStatus _VI_FUNC hpe1432_readRawData  (ViSession vi, ViInt32 group, ViInt32 which, ViChar data[], ViInt32 size, ViPInt32 actualCnt, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_readRegister16  (ViSession vi, ViInt32 channel, ViInt32 reg, ViPInt16 data);

ViStatus _VI_FUNC hpe1432_readRegister32  (ViSession vi, ViInt32 channel, ViInt32 reg, ViPInt32 data);

ViStatus _VI_FUNC hpe1432_readTrailerData  (ViSession vi, ViPReal64 trig, ViPReal64 zoom, ViPReal64 rpm1, ViPReal64 rpm2, ViPInt32 gap, ViPInt32 info, ViPReal64 peak, ViPReal64 rms);

ViStatus _VI_FUNC hpe1432_reenableInterrupt  (ViSession vi, ViInt32 channel);

ViStatus _VI_FUNC hpe1432_reset  (ViSession vi);

ViStatus _VI_FUNC hpe1432_resetLbus  (ViSession vi, ViInt32 group, ViInt32 lbusReset);

ViStatus _VI_FUNC hpe1432_resetMeasure  (ViSession vi, ViInt32 group);

ViStatus _VI_FUNC hpe1432_revision_query  (ViSession vi, ViChar driver_rev[], ViChar instr_rev[]);

ViStatus _VI_FUNC hpe1432_scaDspDownload  (ViSession vi, ViInt32 group, ViInt32 length, ViPInt32 data);

ViStatus _VI_FUNC hpe1432_scaDspExecQuery  (ViSession vi, ViInt32 group, ViInt32 exec_cmd, ViInt32 exec_data_size, ViPInt32 exec_data, ViInt32 query_data_size, ViPInt32 query_data);

ViStatus _VI_FUNC hpe1432_selftest  (ViSession vi, ViPInt16 testResult, ViChar testMessage[]);

ViStatus _VI_FUNC hpe1432_sendTachs  (ViSession vi, ViInt32 group, ViInt32 tach, ViInt32 tachBuffer[], ViInt32 size, ViPInt32 count);

ViStatus _VI_FUNC hpe1432_sendTrigger  (ViSession vi, ViInt32 group);

ViStatus _VI_FUNC hpe1432_setActive  (ViSession vi, ViInt32 group, ViInt32 active);

ViStatus _VI_FUNC hpe1432_setAmpScale  (ViSession vi, ViInt32 group, ViReal64 ampScale);

ViStatus _VI_FUNC hpe1432_setAnalogInput  (ViSession vi, ViInt32 group, ViInt32 mode, ViInt32 source, ViInt32 state, ViInt32 coupling, ViReal64 range);

ViStatus _VI_FUNC hpe1432_setAntiAliasAnalog  (ViSession vi, ViInt32 group, ViInt32 antiAnalog);

ViStatus _VI_FUNC hpe1432_setAntiAliasDigital  (ViSession vi, ViInt32 group, ViInt32 antiDigital);

ViStatus _VI_FUNC hpe1432_setAppendStatus  (ViSession vi, ViInt32 group, ViInt32 appStatus);

ViStatus _VI_FUNC hpe1432_setArmChannel  (ViSession vi, ViInt32 group, ViInt32 armActive);

ViStatus _VI_FUNC hpe1432_setArmMode  (ViSession vi, ViInt32 group, ViInt32 armMode);

ViStatus _VI_FUNC hpe1432_setArmTimeInterval  (ViSession vi, ViInt32 group, ViReal64 armTimeInt);

ViStatus _VI_FUNC hpe1432_setAutoGroupMeas  (ViSession vi, ViInt32 group, ViInt32 autoGroupMeas);

ViStatus _VI_FUNC hpe1432_setAutoRangeMode  (ViSession vi, ViInt32 group, ViInt32 rangeMode);

ViStatus _VI_FUNC hpe1432_setAutoTrigger  (ViSession vi, ViInt32 group, ViInt32 autoTrigger);

ViStatus _VI_FUNC hpe1432_setAvgMode  (ViSession vi, ViInt32 group, ViInt32 avgMode);

ViStatus _VI_FUNC hpe1432_setAvgNumber  (ViSession vi, ViInt32 group, ViInt32 avgNum);

ViStatus _VI_FUNC hpe1432_setAvgUpdate  (ViSession vi, ViInt32 group, ViInt32 avgUp);

ViStatus _VI_FUNC hpe1432_setAvgWeight  (ViSession vi, ViInt32 group, ViReal64 avgWt);

ViStatus _VI_FUNC hpe1432_setBlocksize  (ViSession vi, ViInt32 group, ViInt32 blocksize);

ViStatus _VI_FUNC hpe1432_setCalDac  (ViSession vi, ViInt32 group, ViInt32 calDac);

ViStatus _VI_FUNC hpe1432_setCalVoltage  (ViSession vi, ViInt32 group, ViReal64 calVolts);

ViStatus _VI_FUNC hpe1432_setCalcData  (ViSession vi, ViInt32 group, ViInt32 calcData);

ViStatus _VI_FUNC hpe1432_setCalin  (ViSession vi, ViInt32 group, ViInt32 calInStatus);

ViStatus _VI_FUNC hpe1432_setCenterFreq  (ViSession vi, ViInt32 group, ViReal64 centerFreq);

ViStatus _VI_FUNC hpe1432_setClockFreq  (ViSession vi, ViInt32 group, ViReal64 clockFreq);

ViStatus _VI_FUNC hpe1432_setClockMaster  (ViSession vi, ViInt32 group, ViInt32 clockMasterStatus);

ViStatus _VI_FUNC hpe1432_setClockSource  (ViSession vi, ViInt32 group, ViInt32 clockSource);

ViStatus _VI_FUNC hpe1432_setCoupling  (ViSession vi, ViInt32 group, ViInt32 coupling);

ViStatus _VI_FUNC hpe1432_setCouplingFreq  (ViSession vi, ViInt32 group, ViReal64 couplingFreq);

ViStatus _VI_FUNC hpe1432_setDataFormat  (ViSession vi, ViInt32 group, ViInt32 blocksize, ViInt32 dataSize, ViInt32 mode, ViInt32 append);

ViStatus _VI_FUNC hpe1432_setDataMode  (ViSession vi, ViInt32 group, ViInt32 dataMode);

ViStatus _VI_FUNC hpe1432_setDataPort  (ViSession vi, ViInt32 group, ViInt32 dataPort);

ViStatus _VI_FUNC hpe1432_setDataSize  (ViSession vi, ViInt32 group, ViInt32 dataSize);

ViStatus _VI_FUNC hpe1432_setDecimationOutput  (ViSession vi, ViInt32 group, ViInt32 decOut);

ViStatus _VI_FUNC hpe1432_setDecimationOversample  (ViSession vi, ViInt32 group, ViInt32 decOversamp);

ViStatus _VI_FUNC hpe1432_setDecimationUndersamp  (ViSession vi, ViInt32 group, ViInt32 undersamp);

ViStatus _VI_FUNC hpe1432_setDeltaOrder  (ViSession vi, ViInt32 group, ViReal64 delOrder);

ViStatus _VI_FUNC hpe1432_setDutyCycle  (ViSession vi, ViInt32 group, ViReal64 dutyCycle);

ViStatus _VI_FUNC hpe1432_setEnable  (ViSession vi, ViInt32 group, ViInt32 dataType, ViInt32 enable);

ViStatus _VI_FUNC hpe1432_setFifoSize  (ViSession vi, ViInt32 group, ViInt32 fifoSize);

ViStatus _VI_FUNC hpe1432_setFilterFreq  (ViSession vi, ViInt32 group, ViReal64 filterFreq);

ViStatus _VI_FUNC hpe1432_setFilterSettlingTime  (ViSession vi, ViInt32 group, ViReal64 filtSetTime);

ViStatus _VI_FUNC hpe1432_setInputHigh  (ViSession vi, ViInt32 group, ViInt32 inputHigh);

ViStatus _VI_FUNC hpe1432_setInputLow  (ViSession vi, ViInt32 group, ViInt32 inputLow);

ViStatus _VI_FUNC hpe1432_setInputMode  (ViSession vi, ViInt32 group, ViInt32 inputMode);

ViStatus _VI_FUNC hpe1432_setInputOffset  (ViSession vi, ViInt32 group, ViReal64 inputOffset);

ViStatus _VI_FUNC hpe1432_setInterrupt  (ViSession vi, ViInt32 group, ViInt32 priority, ViInt32 mask);

ViStatus _VI_FUNC hpe1432_setInterruptMask  (ViSession vi, ViInt32 group, ViInt32 intMask);

ViStatus _VI_FUNC hpe1432_setInterruptPriority  (ViSession vi, ViInt32 group, ViInt32 priority);

ViStatus _VI_FUNC hpe1432_setLbusMode  (ViSession vi, ViInt32 group, ViInt32 lbusMode);

ViStatus _VI_FUNC hpe1432_setMaxOrder  (ViSession vi, ViInt32 group, ViReal64 maxOrder);

ViStatus _VI_FUNC hpe1432_setMeasTimeLength  (ViSession vi, ViInt32 group, ViReal64 measTime);

ViStatus _VI_FUNC hpe1432_setMmfDelay  (ViSession vi, ViInt32 group, ViInt32 mmfdelay);

ViStatus _VI_FUNC hpe1432_setMultiSync  (ViSession vi, ViInt32 group, ViInt32 multiSync);

ViStatus _VI_FUNC hpe1432_setOctaveAvgMode  (ViSession vi, ViInt32 group, ViInt32 octAvgMode);

ViStatus _VI_FUNC hpe1432_setOctaveHoldMode  (ViSession vi, ViInt32 group, ViInt32 octHoldMode);

ViStatus _VI_FUNC hpe1432_setOctaveIntTime  (ViSession vi, ViInt32 group, ViReal64 octIntTime);

ViStatus _VI_FUNC hpe1432_setOctaveMeas  (ViSession vi, ViInt32 group, ViInt32 octAvgMode);

ViStatus _VI_FUNC hpe1432_setOctaveMode  (ViSession vi, ViInt32 group, ViInt32 OctaveMode);

ViStatus _VI_FUNC hpe1432_setOctaveStartFreq  (ViSession vi, ViInt32 group, ViReal64 octStartFreq);

ViStatus _VI_FUNC hpe1432_setOctaveStopFreq  (ViSession vi, ViInt32 group, ViReal64 octStopFreq);

ViStatus _VI_FUNC hpe1432_setOctaveTimeConst  (ViSession vi, ViInt32 group, ViReal64 octTimeConst);

ViStatus _VI_FUNC hpe1432_setOctaveTimeStep  (ViSession vi, ViInt32 group, ViReal64 octTimeStep);

ViStatus _VI_FUNC hpe1432_setOverlap  (ViSession vi, ViInt32 group, ViInt32 overlap);

ViStatus _VI_FUNC hpe1432_setPeakDecayTime  (ViSession vi, ViInt32 group, ViReal64 peakDecayTime);

ViStatus _VI_FUNC hpe1432_setPeakMode  (ViSession vi, ViInt32 group, ViInt32 peakMode);

ViStatus _VI_FUNC hpe1432_setPreArmMode  (ViSession vi, ViInt32 group, ViInt32 preArmMode);

ViStatus _VI_FUNC hpe1432_setPreArmRpm  (ViSession vi, ViInt32 group, ViReal64 preArmRpm);

ViStatus _VI_FUNC hpe1432_setRamp  (ViSession vi, ViInt32 group, ViInt32 ramp);

ViStatus _VI_FUNC hpe1432_setRampRate  (ViSession vi, ViInt32 group, ViReal64 rampRate);

ViStatus _VI_FUNC hpe1432_setRange  (ViSession vi, ViInt32 group, ViReal64 range);

ViStatus _VI_FUNC hpe1432_setRangeCharge  (ViSession vi, ViInt32 group, ViReal64 range);

ViStatus _VI_FUNC hpe1432_setRangeMike  (ViSession vi, ViInt32 group, ViReal64 range);

ViStatus _VI_FUNC hpe1432_setRmsAvgTime  (ViSession vi, ViInt32 group, ViReal64 rmsAvgTime);

ViStatus _VI_FUNC hpe1432_setRmsDecayTime  (ViSession vi, ViInt32 group, ViReal64 decayTime);

ViStatus _VI_FUNC hpe1432_setRmsMode  (ViSession vi, ViInt32 group, ViInt32 rmsMode);

ViStatus _VI_FUNC hpe1432_setRpmHigh  (ViSession vi, ViInt32 group, ViReal64 rpmHigh);

ViStatus _VI_FUNC hpe1432_setRpmInterval  (ViSession vi, ViInt32 group, ViReal64 rpmInt);

ViStatus _VI_FUNC hpe1432_setRpmLow  (ViSession vi, ViInt32 group, ViReal64 rpmLow);

ViStatus _VI_FUNC hpe1432_setRpmSmoothing  (ViSession vi, ViInt32 group, ViReal64 rpmSmooth);

ViStatus _VI_FUNC hpe1432_setSampleMode  (ViSession vi, ViInt32 group, ViInt32 sampleMode);

ViStatus _VI_FUNC hpe1432_setSineFreq  (ViSession vi, ViInt32 group, ViReal64 sineFreq);

ViStatus _VI_FUNC hpe1432_setSinePhase  (ViSession vi, ViInt32 group, ViReal64 sinePhase);

ViStatus _VI_FUNC hpe1432_setSourceBlocksize  (ViSession vi, ViInt32 group, ViInt32 srcBlocksize);

ViStatus _VI_FUNC hpe1432_setSourceCenterFreq  (ViSession vi, ViInt32 group, ViReal64 srcCenterFreq);

ViStatus _VI_FUNC hpe1432_setSourceCola  (ViSession vi, ViInt32 group, ViInt32 srcCola);

ViStatus _VI_FUNC hpe1432_setSourceMode  (ViSession vi, ViInt32 group, ViInt32 srcMode);

ViStatus _VI_FUNC hpe1432_setSourceOutput  (ViSession vi, ViInt32 group, ViInt32 srcOutput);

ViStatus _VI_FUNC hpe1432_setSourceSeed  (ViSession vi, ViInt32 group, ViInt32 srcSeed);

ViStatus _VI_FUNC hpe1432_setSourceSpan  (ViSession vi, ViInt32 group, ViReal64 srcSpan);

ViStatus _VI_FUNC hpe1432_setSourceSum  (ViSession vi, ViInt32 group, ViInt32 srcSum);

ViStatus _VI_FUNC hpe1432_setSpan  (ViSession vi, ViInt32 group, ViReal64 span);

ViStatus _VI_FUNC hpe1432_setSrcBufferInit  (ViSession vi, ViInt32 group, ViInt32 srcBufInit);

ViStatus _VI_FUNC hpe1432_setSrcBufferMode  (ViSession vi, ViInt32 group, ViInt32 srcBufMode);

ViStatus _VI_FUNC hpe1432_setSrcBufferSize  (ViSession vi, ViInt32 group, ViInt32 srcBufSize);

ViStatus _VI_FUNC hpe1432_setSrcParmMode  (ViSession vi, ViInt32 group, ViInt32 srcParmMode);

ViStatus _VI_FUNC hpe1432_setSumbus  (ViSession vi, ViInt32 group, ViInt32 sumbus);

ViStatus _VI_FUNC hpe1432_setTachDecimate  (ViSession vi, ViInt32 group, ViInt32 tachDec);

ViStatus _VI_FUNC hpe1432_setTachHoldoff  (ViSession vi, ViInt32 group, ViReal64 tachHoldoff);

ViStatus _VI_FUNC hpe1432_setTachIrqNumber  (ViSession vi, ViInt32 group, ViInt32 irqNum);

ViStatus _VI_FUNC hpe1432_setTachMaxTime  (ViSession vi, ViInt32 group, ViReal64 tachMaxTime);

ViStatus _VI_FUNC hpe1432_setTachPpr  (ViSession vi, ViInt32 group, ViReal64 tachPpr);

ViStatus _VI_FUNC hpe1432_setTraceLevel  (ViSession vi, ViInt32 tlevel);

ViStatus _VI_FUNC hpe1432_setTrigger  (ViSession vi, ViInt32 group, ViInt32 state, ViInt32 delay, ViReal64 level0, ViReal64 level1, ViInt32 slope, ViInt32 mode);

ViStatus _VI_FUNC hpe1432_setTriggerChannel  (ViSession vi, ViInt32 group, ViInt32 trigChan);

ViStatus _VI_FUNC hpe1432_setTriggerDelay  (ViSession vi, ViInt32 group, ViInt32 trigDelay);

ViStatus _VI_FUNC hpe1432_setTriggerExt  (ViSession vi, ViInt32 group, ViInt32 trigExt);

ViStatus _VI_FUNC hpe1432_setTriggerLevel  (ViSession vi, ViInt32 group, ViInt32 selectLevel, ViReal64 trigLevel);

ViStatus _VI_FUNC hpe1432_setTriggerMaster  (ViSession vi, ViInt32 group, ViInt32 trigMaster);

ViStatus _VI_FUNC hpe1432_setTriggerMode  (ViSession vi, ViInt32 group, ViInt32 trigMode);

ViStatus _VI_FUNC hpe1432_setTriggerSlope  (ViSession vi, ViInt32 group, ViInt32 trigSlope);

ViStatus _VI_FUNC hpe1432_setTriggersPerArm  (ViSession vi, ViInt32 group, ViInt32 trigsPerArm);

ViStatus _VI_FUNC hpe1432_setTtltrgClock  (ViSession vi, ViInt32 group, ViInt32 ttlClock);

ViStatus _VI_FUNC hpe1432_setTtltrgGclock  (ViSession vi, ViInt32 group, ViInt32 ttltrgGClock);

ViStatus _VI_FUNC hpe1432_setTtltrgLines  (ViSession vi, ViInt32 group, ViInt32 ttltrgLines);

ViStatus _VI_FUNC hpe1432_setTtltrgSatrg  (ViSession vi, ViInt32 group, ViInt32 ttltrgSatrg);

ViStatus _VI_FUNC hpe1432_setTtltrgTrigger  (ViSession vi, ViInt32 group, ViInt32 ttltrgTrig);

ViStatus _VI_FUNC hpe1432_setUserData  (ViSession vi, ViInt32 group, ViInt32 frameLen, ViInt32 wordLen, ViInt32 subLen, ViInt32 subPos);

ViStatus _VI_FUNC hpe1432_setUserWindow  (ViSession vi, ViInt32 group, ViReal64 window[], ViReal64 wscale);

ViStatus _VI_FUNC hpe1432_setWeighting  (ViSession vi, ViInt32 group, ViInt32 weight);

ViStatus _VI_FUNC hpe1432_setWindow  (ViSession vi, ViInt32 group, ViInt32 window);

ViStatus _VI_FUNC hpe1432_setXferSize  (ViSession vi, ViInt32 group, ViInt32 xferSize);

ViStatus _VI_FUNC hpe1432_setZoom  (ViSession vi, ViInt32 group, ViInt32 zoom);

ViStatus _VI_FUNC hpe1432_srcGetFwrev  (ViSession vi, ViInt32 dptr[], ViPInt32 fwid, ViPInt32 fwdate, ViInt32 numwords);

ViStatus _VI_FUNC hpe1432_srcGetRev  (ViSession vi, ViInt32 chan, ViPInt32 romid, ViPInt32 romdate, ViPInt32 bdid, ViChar bddate[]);

ViStatus _VI_FUNC hpe1432_srcProgRomImage  (ViSession vi, ViInt32 chan, ViInt32 data[], ViInt32 numwords);

ViStatus _VI_FUNC hpe1432_srcRxfr  (ViSession vi, ViInt32 chan, ViInt32 numwords, ViInt32 data[], ViInt32 mode);

ViStatus _VI_FUNC hpe1432_triggerMeasure  (ViSession vi, ViInt32 group, ViInt32 wait);

ViStatus _VI_FUNC hpe1432_updateSrcParm  (ViSession vi, ViInt32 group, ViInt32 updateMode);

ViStatus _VI_FUNC hpe1432_writeI2C  (ViSession vi, ViInt32 group, ViInt32 address, ViInt32 i2cdata);

ViStatus _VI_FUNC hpe1432_writeRegister16  (ViSession vi, ViInt32 channel, ViInt32 reg, ViInt16 data);

ViStatus _VI_FUNC hpe1432_writeRegister32  (ViSession vi, ViInt32 channel, ViInt32 reg, ViInt32 data);

ViStatus _VI_FUNC hpe1432_writeSrcBufferData  (ViSession vi, ViInt32 chan, ViInt32 dataPtr[], ViInt32 numWords, ViInt32 mode);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1432_INCLUDE */

